/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.teolenn.measurement.io;

import fr.ens.transcriptome.teolenn.measurement.io.SequenceMeasurementsWriter;
import fr.ens.transcriptome.teolenn.sequence.SequenceMeasurements;
import fr.ens.transcriptome.teolenn.util.FileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;

public final class FileSequenceMeasurementsWriter
implements SequenceMeasurementsWriter {
    private static final int WRITE_BUFFER_LEN = 1000000;
    private Writer writer;
    private final StringBuilder buffer = new StringBuilder(1050000);
    private boolean headerDone;

    private void writeHeader(SequenceMeasurements sm) throws IOException {
        if (this.headerDone) {
            return;
        }
        this.buffer.append("Id");
        String[] names = sm.getArrayMesurementNames();
        for (int i = 0; i < names.length; ++i) {
            this.buffer.append("\t");
            this.buffer.append(names[i]);
        }
        this.buffer.append("\n");
        this.writer.append(this.buffer.toString());
        this.buffer.setLength(0);
        this.headerDone = true;
    }

    public void writeSequenceMesurement(SequenceMeasurements sm) throws IOException {
        if (this.writer == null) {
            return;
        }
        if (!this.headerDone) {
            this.writeHeader(sm);
        }
        this.buffer.append(sm.getId());
        Object[] values = sm.getArrayMeasurementValues();
        for (int i = 0; i < values.length; ++i) {
            this.buffer.append("\t");
            this.buffer.append(values[i]);
        }
        this.buffer.append("\n");
        if (this.buffer.length() > 1000000) {
            this.writer.append(this.buffer.toString());
            this.buffer.setLength(0);
        }
    }

    public void close() throws IOException {
        this.writer.append(this.buffer.toString());
        this.writer.close();
        this.writer = null;
    }

    public FileSequenceMeasurementsWriter(File file) throws FileNotFoundException {
        if (file == null) {
            throw new NullPointerException("File is null");
        }
        this.writer = FileUtils.createBufferedWriter(file);
    }
}

