/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.teolenn.measurement.io;

import fr.ens.transcriptome.teolenn.measurement.io.SequenceMeasurementsReader;
import fr.ens.transcriptome.teolenn.sequence.SequenceMeasurements;
import fr.ens.transcriptome.teolenn.util.FileUtils;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.logging.Logger;

public class FilteredSequenceMeasurementsReader
implements SequenceMeasurementsReader {
    private static Logger logger = Logger.getLogger("Teolenn");
    private static final String SERIALIZED_FORMAT_VERSION = "TEOLENN__FILTERED_MES_1";
    private SequenceMeasurementsReader reader;
    private ObjectInputStream in;

    private void readHeader() throws IOException {
        String cookie = this.in.readUTF();
        if (!SERIALIZED_FORMAT_VERSION.equals(cookie)) {
            logger.severe("Invalid measurement version file");
            throw new IOException("Invalid measurement version file");
        }
    }

    public SequenceMeasurements next() throws IOException {
        return this.next(null);
    }

    public SequenceMeasurements next(SequenceMeasurements sm) throws IOException {
        int nextId;
        SequenceMeasurements result = sm;
        try {
            nextId = this.in.readInt();
        }
        catch (EOFException e) {
            return null;
        }
        int readId = -1;
        while (readId != nextId) {
            if ((result = this.reader.next(result)) == null) {
                return null;
            }
            readId = result.getId();
        }
        return result;
    }

    public void close() throws IOException {
        this.reader.close();
        this.in.close();
    }

    public FilteredSequenceMeasurementsReader(File file, SequenceMeasurementsReader reader) throws IOException {
        if (file == null) {
            throw new NullPointerException("File is null");
        }
        if (reader == null) {
            throw new NullPointerException("Measurement file is null");
        }
        this.in = FileUtils.createObjectInputReader(file);
        this.reader = reader;
        this.readHeader();
    }
}

