/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.teolenn.measurement.io;

import fr.ens.transcriptome.teolenn.measurement.io.SequenceMeasurementsWriter;
import fr.ens.transcriptome.teolenn.sequence.SequenceMeasurements;
import fr.ens.transcriptome.teolenn.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;

public class FilteredSequenceMeasurementsWriter
implements SequenceMeasurementsWriter {
    private static final String SERIALIZED_FORMAT_VERSION = "TEOLENN__FILTERED_MES_1";
    private ObjectOutputStream out;
    private boolean headerDone;

    private void writeHeader(SequenceMeasurements sm) throws IOException {
        if (this.headerDone) {
            return;
        }
        this.out.writeUTF(SERIALIZED_FORMAT_VERSION);
        this.headerDone = true;
    }

    public void writeSequenceMesurement(SequenceMeasurements sm) throws IOException {
        if (this.out == null) {
            return;
        }
        if (!this.headerDone) {
            this.writeHeader(sm);
        }
        int id = sm.getId();
        this.out.writeInt(id);
        if (id % 100000 == 0) {
            this.out.reset();
        }
    }

    public void close() throws IOException {
        this.out.close();
        this.out = null;
    }

    public FilteredSequenceMeasurementsWriter(File outputFile) throws IOException {
        if (outputFile == null) {
            throw new NullPointerException("File is null");
        }
        this.out = FileUtils.createObjectOutputWriter(outputFile);
    }
}

