/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.teolenn.measurement.io;

import fr.ens.transcriptome.teolenn.Settings;
import fr.ens.transcriptome.teolenn.measurement.io.FileSequenceMeasurementsReader;
import fr.ens.transcriptome.teolenn.measurement.io.FileSequenceMeasurementsWriter;
import fr.ens.transcriptome.teolenn.measurement.io.FilteredSequenceMeasurementsReader;
import fr.ens.transcriptome.teolenn.measurement.io.FilteredSequenceMeasurementsWriter;
import fr.ens.transcriptome.teolenn.measurement.io.SequenceMeasurementsReader;
import fr.ens.transcriptome.teolenn.measurement.io.SequenceMeasurementsWriter;
import fr.ens.transcriptome.teolenn.measurement.io.SerializedSequenceMeasurementsReader;
import fr.ens.transcriptome.teolenn.measurement.io.SerializedSequenceMeasurementsWriter;
import java.io.File;
import java.io.IOException;

public class SequenceMeasurementsIOFactory {
    public static final SequenceMeasurementsReader createSequenceMeasurementsReader(File file) throws IOException {
        if (Settings.isMeasurementFileSerialized()) {
            return new SerializedSequenceMeasurementsReader(file);
        }
        return new FileSequenceMeasurementsReader(file);
    }

    public static final SequenceMeasurementsWriter createSequenceMeasurementsWriter(File file) throws IOException {
        if (Settings.isMeasurementFileSerialized()) {
            return new SerializedSequenceMeasurementsWriter(file);
        }
        return new FileSequenceMeasurementsWriter(file);
    }

    public static final SequenceMeasurementsReader createSequenceMeasurementsFilteredReader(File filteredFile, File originalFile) throws IOException {
        if (Settings.isMeasurementFileSerialized()) {
            return new FilteredSequenceMeasurementsReader(filteredFile, SequenceMeasurementsIOFactory.createSequenceMeasurementsReader(originalFile));
        }
        return SequenceMeasurementsIOFactory.createSequenceMeasurementsReader(filteredFile);
    }

    public static final SequenceMeasurementsWriter createSequenceMeasurementsFilteredWriter(File filteredFile, File originalFile) throws IOException {
        if (Settings.isMeasurementFileSerialized()) {
            return new FilteredSequenceMeasurementsWriter(filteredFile);
        }
        return SequenceMeasurementsIOFactory.createSequenceMeasurementsWriter(filteredFile);
    }

    public static final SequenceMeasurementsWriter createSequenceMeasurementsSelectWriter(File file) throws IOException {
        return new FileSequenceMeasurementsWriter(file);
    }
}

