/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.teolenn.measurement.io;

import fr.ens.transcriptome.teolenn.measurement.Measurement;
import fr.ens.transcriptome.teolenn.measurement.MeasurementRegistery;
import fr.ens.transcriptome.teolenn.measurement.io.SequenceMeasurementsReader;
import fr.ens.transcriptome.teolenn.sequence.SequenceMeasurements;
import fr.ens.transcriptome.teolenn.util.FileUtils;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class SerializedSequenceMeasurementsReader
implements SequenceMeasurementsReader {
    private static Logger logger = Logger.getLogger("Teolenn");
    private static final String SERIALIZED_FORMAT_VERSION = "TEOLENN_MES_2";
    private ObjectInputStream in;
    private Measurement[] ms;
    private int[] types;
    private final Map<Integer, String> indexChromosomeNames = new HashMap<Integer, String>();
    private int typeDataChromosomeName;
    private String currentChr;
    private int chrNameIndex = -1;
    private int indexChr = -1;

    private void readHeader() throws IOException {
        try {
            int i;
            String cookie = this.in.readUTF();
            if (!SERIALIZED_FORMAT_VERSION.equals(cookie)) {
                logger.severe("Invalid measurement version file");
                throw new IOException("Invalid measurement version file");
            }
            this.in.readUTF();
            String[] mNames = (String[])this.in.readObject();
            this.ms = new Measurement[mNames.length];
            for (i = 0; i < mNames.length; ++i) {
                Measurement m = MeasurementRegistery.getMeasurement(mNames[i]);
                if (m == null) {
                    throw new RuntimeException("Unknown measurement: " + mNames[i]);
                }
                this.ms[i] = m;
            }
            this.types = new int[this.ms.length];
            for (i = 0; i < this.ms.length; ++i) {
                Object objType = this.ms[i].getType();
                if (Float.class == objType) {
                    this.types[i] = 1;
                    continue;
                }
                if (Integer.class == objType) {
                    this.types[i] = 3;
                    continue;
                }
                if (String.class == objType) {
                    this.types[i] = 5;
                    continue;
                }
                logger.severe("Unknown datatype: " + objType);
                throw new IOException("Unknown datatype: " + objType);
            }
            this.typeDataChromosomeName = this.in.readInt();
            String[] chrNames = (String[])this.in.readObject();
            for (int i2 = 0; i2 < chrNames.length; ++i2) {
                this.indexChromosomeNames.put(i2, chrNames[i2]);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.currentChr = null;
        this.chrNameIndex = -1;
    }

    public SequenceMeasurements next() throws IOException {
        return this.next(null);
    }

    public SequenceMeasurements next(SequenceMeasurements sm) throws IOException {
        SequenceMeasurements result;
        if (sm == null) {
            result = new SequenceMeasurements();
            for (int i = 0; i < this.ms.length; ++i) {
                result.addMesurement(this.ms[i]);
            }
            result.setArrayMeasurementValues(new Object[this.ms.length]);
            this.indexChr = result.getIndexMeasurment("Chromosome");
        } else {
            result = sm;
        }
        try {
            result.setId(this.in.readInt());
        }
        catch (EOFException e) {
            return null;
        }
        Object[] values = result.getArrayMeasurementValues();
        int len = this.ms.length;
        block13: for (int i = 0; i < len; ++i) {
            if (i == this.indexChr) {
                int val;
                switch (this.typeDataChromosomeName) {
                    case 2: {
                        val = this.in.readByte();
                        break;
                    }
                    case 4: {
                        val = this.in.readShort();
                        break;
                    }
                    case 3: {
                        val = this.in.readInt();
                        break;
                    }
                    default: {
                        val = -10;
                    }
                }
                if (val == this.chrNameIndex) {
                    values[i] = this.currentChr;
                    continue;
                }
                this.chrNameIndex = val;
                this.currentChr = this.indexChromosomeNames.get(val);
                values[i] = this.currentChr;
                continue;
            }
            switch (this.types[i]) {
                case 1: {
                    values[i] = Float.valueOf(this.in.readFloat());
                    continue block13;
                }
                case 3: {
                    values[i] = this.in.readInt();
                    continue block13;
                }
                case 5: {
                    values[i] = this.in.readUTF();
                    continue block13;
                }
            }
        }
        return result;
    }

    public void close() throws IOException {
        this.in.close();
    }

    public SerializedSequenceMeasurementsReader(File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("File is null");
        }
        this.in = FileUtils.createObjectInputReader(file);
        this.readHeader();
    }
}

