/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.teolenn.measurement.io;

import fr.ens.transcriptome.teolenn.TeolennException;
import fr.ens.transcriptome.teolenn.measurement.io.SequenceMeasurementsWriter;
import fr.ens.transcriptome.teolenn.resource.ChromosomeNameResource;
import fr.ens.transcriptome.teolenn.sequence.SequenceMeasurements;
import fr.ens.transcriptome.teolenn.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class SerializedSequenceMeasurementsWriter
implements SequenceMeasurementsWriter {
    private static Logger logger = Logger.getLogger("Teolenn");
    private static final String SERIALIZED_FORMAT_VERSION = "TEOLENN_MES_2";
    private ObjectOutputStream out;
    private ChromosomeNameResource resource;
    private final Map<String, Integer> indexChromosomeNames = new HashMap<String, Integer>();
    private int typeDataChromosomeName;
    private int indexChr;
    private boolean headerDone;
    private int[] types;

    private void writeHeader(SequenceMeasurements sm) throws IOException {
        if (this.headerDone) {
            return;
        }
        this.out.writeUTF(SERIALIZED_FORMAT_VERSION);
        this.out.writeUTF("Id");
        String[] names = sm.getArrayMesurementNames();
        this.out.writeObject(names);
        this.types = new int[names.length];
        for (int i = 0; i < names.length; ++i) {
            Object objType = sm.getMeasurement(names[i]).getType();
            if (Float.class == objType) {
                this.types[i] = 1;
                continue;
            }
            if (Integer.class == objType) {
                this.types[i] = 3;
                continue;
            }
            if (String.class == objType) {
                this.types[i] = 5;
                continue;
            }
            logger.severe("Unknown datatype: " + objType);
            throw new IOException("Unknown datatype: " + objType);
        }
        List<String> chrNames = this.resource.getChromosomesNames();
        int nbChr = chrNames.size();
        if (nbChr >= 0 && nbChr <= 127) {
            this.typeDataChromosomeName = 2;
        } else if (nbChr > 127 && nbChr <= Short.MAX_VALUE) {
            this.typeDataChromosomeName = 4;
        } else if (nbChr > Short.MAX_VALUE) {
            this.typeDataChromosomeName = 1;
        }
        this.out.writeInt(this.typeDataChromosomeName);
        int i = 0;
        for (String chrName : chrNames) {
            this.indexChromosomeNames.put(chrName, i++);
        }
        String[] chrNamesArray = new String[chrNames.size()];
        chrNames.toArray(chrNamesArray);
        this.out.writeObject(chrNamesArray);
        this.indexChr = -1;
        this.headerDone = true;
    }

    public void writeSequenceMesurement(SequenceMeasurements sm) throws IOException {
        if (this.out == null) {
            return;
        }
        String lastChr = null;
        Number chrNameIndex = null;
        if (!this.headerDone) {
            this.writeHeader(sm);
            this.indexChr = sm.getIndexMeasurment("Chromosome");
            this.types[this.indexChr] = this.typeDataChromosomeName;
        }
        int id = sm.getId();
        this.out.writeInt(id);
        Object[] values = sm.getArrayMeasurementValues();
        int len = values.length;
        block12: for (int i = 0; i < len; ++i) {
            Object val;
            if (i == this.indexChr) {
                String chr = (String)values[i];
                if (chr != lastChr) {
                    int idx = this.indexChromosomeNames.get(chr);
                    switch (this.typeDataChromosomeName) {
                        case 2: {
                            chrNameIndex = (byte)idx;
                            break;
                        }
                        case 4: {
                            chrNameIndex = (short)idx;
                            break;
                        }
                        case 3: {
                            chrNameIndex = idx;
                        }
                    }
                    lastChr = chr;
                }
                val = chrNameIndex;
            } else {
                val = values[i];
            }
            switch (this.types[i]) {
                case 1: {
                    this.out.writeFloat(((Float)val).floatValue());
                    continue block12;
                }
                case 2: {
                    this.out.writeByte(((Byte)val).byteValue());
                    continue block12;
                }
                case 3: {
                    this.out.writeInt((Integer)val);
                    continue block12;
                }
                case 4: {
                    this.out.writeShort(((Short)val).shortValue());
                    continue block12;
                }
                case 5: {
                    this.out.writeUTF((String)val);
                    continue block12;
                }
            }
        }
        if (id % 100000 == 0) {
            this.out.reset();
        }
    }

    public void close() throws IOException {
        this.out.close();
        this.out = null;
    }

    public SerializedSequenceMeasurementsWriter(File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("File is null");
        }
        this.out = FileUtils.createObjectOutputWriter(file);
        try {
            this.resource = ChromosomeNameResource.getRessource();
        }
        catch (TeolennException e) {
            throw new IOException("None chromosome name found");
        }
    }
}

