/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.teolenn.output;

import fr.ens.transcriptome.teolenn.TeolennException;
import fr.ens.transcriptome.teolenn.measurement.io.SequenceMeasurementsIOFactory;
import fr.ens.transcriptome.teolenn.measurement.io.SequenceMeasurementsWriter;
import fr.ens.transcriptome.teolenn.output.Output;
import fr.ens.transcriptome.teolenn.sequence.SequenceMeasurements;
import java.io.File;
import java.io.IOException;

public class DefaultOutput
implements Output {
    private SequenceMeasurementsWriter writer;
    private File outputFile;
    private String outputDefaultFile;
    public static final String OUTPUT_NAME = "default";

    public String getDescription() {
        return "Write SequenceMeasurement in default format";
    }

    public String getName() {
        return OUTPUT_NAME;
    }

    public void init() throws TeolennException {
        if (this.outputFile == null) {
            this.outputFile = new File(this.outputDefaultFile);
        }
        try {
            this.writer = SequenceMeasurementsIOFactory.createSequenceMeasurementsSelectWriter(this.outputFile);
        }
        catch (IOException e) {
            throw new TeolennException(e);
        }
    }

    public void setInitParameter(String key, String value) {
        if (key == null || value == null) {
            return;
        }
        if ("_outputdefaultfile".equals(key)) {
            this.outputDefaultFile = value;
        }
        if ("outputfile".equals(key)) {
            this.outputFile = new File(value);
        }
    }

    public void writeSequenceMesurement(SequenceMeasurements sm) throws IOException {
        this.writer.writeSequenceMesurement(sm);
    }

    public void close() throws IOException {
        this.writer.close();
    }
}

