/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.teolenn.output;

import fr.ens.transcriptome.teolenn.TeolennException;
import fr.ens.transcriptome.teolenn.output.Output;
import fr.ens.transcriptome.teolenn.resource.ORFResource;
import fr.ens.transcriptome.teolenn.resource.OligoSequenceResource;
import fr.ens.transcriptome.teolenn.sequence.Sequence;
import fr.ens.transcriptome.teolenn.sequence.SequenceMeasurements;
import fr.ens.transcriptome.teolenn.sequence.SequenceWriter;
import fr.ens.transcriptome.teolenn.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class FastaOutput
implements Output {
    public static final String OUTPUT_NAME = "fasta";
    private boolean first = true;
    private int indexStart = -1;
    private int indexChromosome = -1;
    private int indexORF = -1;
    private int indexLength = -1;
    private File outputFile;
    private String outputDefaultFile;
    private boolean rcORF = true;
    private boolean rc12;
    private SequenceWriter writer;
    private OligoSequenceResource fastaReader;
    private Sequence sequence = new Sequence();
    private boolean reverseNextSequence;

    public String getDescription() {
        return "Write SequenceMeasurement to Fasta format";
    }

    public String getName() {
        return OUTPUT_NAME;
    }

    public void init() throws TeolennException {
        if (this.outputFile == null) {
            this.outputFile = new File(StringUtils.basename(this.outputDefaultFile) + ".fasta");
        }
        try {
            this.writer = new SequenceWriter(this.outputFile);
        }
        catch (IOException e) {
            throw new TeolennException(e);
        }
        this.fastaReader = OligoSequenceResource.getRessource();
    }

    public void setInitParameter(String key, String value) {
        if (key == null || value == null) {
            return;
        }
        if ("_outputdefaultfile".equals(key)) {
            this.outputDefaultFile = value;
        }
        if ("outputfile".equals(key)) {
            this.outputFile = new File(value);
        }
        if ("rcorf".equals(key)) {
            this.rcORF = Boolean.parseBoolean(value);
        }
        if ("rc12".equals(key)) {
            this.rc12 = Boolean.parseBoolean(value);
        }
    }

    public void writeSequenceMesurement(SequenceMeasurements sm) throws IOException {
        Object[] values;
        if (this.writer == null) {
            return;
        }
        if (this.first) {
            this.indexStart = sm.getIndexMeasurment("OligoStart");
            this.indexChromosome = sm.getIndexMeasurment("Chromosome");
            this.indexORF = sm.getIndexMeasurment("orf");
            this.indexLength = sm.getIndexMeasurment("OligoLength");
            if (this.indexStart == -1) {
                throw new RuntimeException("Unable to find start measurement.");
            }
            if (this.indexChromosome == -1) {
                throw new RuntimeException("Unable to find chromosome measurement.");
            }
            if (this.indexLength == -1) {
                throw new RuntimeException("Unable to find oligo length measurement.");
            }
            this.first = false;
        }
        if ((values = sm.getArrayMeasurementValues()) == null) {
            throw new RuntimeException("Nothing to write.");
        }
        String chr = (String)values[this.indexChromosome];
        int start = (Integer)values[this.indexStart];
        int length = (Integer)values[this.indexLength];
        try {
            this.sequence = this.fastaReader.getSequence(chr, start, length);
        }
        catch (TeolennException e) {
            throw new IOException("Unable to get the length of chromosome before retrieve oligonucleotide sequence");
        }
        boolean reverse = false;
        if (this.rcORF && this.indexORF != -1 && !((ORFResource.ORF)((List)values[this.indexORF]).get((int)0)).codingStrand) {
            reverse = true;
        }
        if (this.rc12) {
            if (this.reverseNextSequence) {
                reverse = true;
                this.reverseNextSequence = false;
            } else {
                this.reverseNextSequence = true;
            }
        }
        if (reverse) {
            this.sequence.reverseComplementSequence();
        }
        this.writer.write(this.sequence);
    }

    public void close() throws IOException {
        this.fastaReader.close();
        this.writer.close();
    }
}

