/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.teolenn.output;

import fr.ens.transcriptome.teolenn.Globals;
import fr.ens.transcriptome.teolenn.TeolennException;
import fr.ens.transcriptome.teolenn.output.Output;
import fr.ens.transcriptome.teolenn.sequence.SequenceMeasurements;
import fr.ens.transcriptome.teolenn.util.FileUtils;
import fr.ens.transcriptome.teolenn.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.Writer;

public class GFFOutput
implements Output {
    private static final String SEQID_PREFIX = "T_";
    private static final String SOURCE = Globals.APP_NAME_LOWER_CASE;
    private static final String TYPE = "oligo";
    private boolean first = true;
    private int indexStart = -1;
    private int indexChromosome = -1;
    private int indexLength = -1;
    private int indexScore = -1;
    private int indexORF = -1;
    private Writer writer;
    private File outputFile;
    private File outputDir;
    private String outputDefaultFile;
    private int count = 0;
    private final StringBuilder sb = new StringBuilder();
    public static final String OUTPUT_NAME = "gff";

    public String getDescription() {
        return "Write SequenceMeasurement to GFF format";
    }

    public String getName() {
        return OUTPUT_NAME;
    }

    public void init() throws TeolennException {
        if (this.outputFile == null) {
            this.outputFile = new File(StringUtils.basename(this.outputDefaultFile) + ".gff");
        }
        try {
            this.writer = FileUtils.createBufferedWriter(this.outputFile);
            this.writer.write("##gff-version 3\n");
        }
        catch (IOException e) {
            throw new TeolennException(e);
        }
    }

    public void setInitParameter(String key, String value) {
        if (key == null || value == null) {
            return;
        }
        if ("_outputdir".equals(key)) {
            this.outputDir = new File(value);
        }
        if ("_outputdefaultfile".equals(key)) {
            this.outputDefaultFile = value;
        }
        if ("outputfile".equals(key)) {
            this.outputFile = new File(value);
        }
    }

    public void writeSequenceMesurement(SequenceMeasurements sm) throws IOException {
        Object[] values;
        if (this.writer == null) {
            return;
        }
        if (this.first) {
            this.indexStart = sm.getIndexMeasurment("OligoStart");
            this.indexChromosome = sm.getIndexMeasurment("Chromosome");
            this.indexLength = sm.getIndexMeasurment("OligoLength");
            this.indexScore = sm.getIndexMeasurment("GlobalScore");
            this.indexORF = sm.getIndexMeasurment("orf");
            if (this.indexStart == -1) {
                throw new RuntimeException("Unable to find start measurement.");
            }
            if (this.indexChromosome == -1) {
                throw new RuntimeException("Unable to find chromosome measurement.");
            }
            this.first = false;
        }
        if ((values = sm.getArrayMeasurementValues()) == null) {
            throw new RuntimeException("Nothing to write.");
        }
        int start = (Integer)values[this.indexStart];
        int length = (Integer)values[this.indexLength];
        String chr = (String)values[this.indexChromosome];
        float score = ((Float)values[this.indexScore]).floatValue();
        String orf = (String)values[this.indexORF];
        char strand = orf.endsWith("W") ? (char)'+' : '-';
        String phase = ".";
        this.sb.append(chr);
        this.sb.append('\t');
        this.sb.append(SOURCE);
        this.sb.append('\t');
        this.sb.append(TYPE);
        this.sb.append('\t');
        this.sb.append(start);
        this.sb.append('\t');
        this.sb.append(start + length);
        this.sb.append('\t');
        this.sb.append(score);
        this.sb.append('\t');
        this.sb.append(strand);
        this.sb.append('\t');
        this.sb.append(".");
        this.sb.append('\t');
        this.sb.append("ID=");
        this.sb.append(sm.getId());
        this.sb.append('\n');
        this.writer.write(this.sb.toString());
        this.sb.setLength(0);
    }

    public void close() throws IOException {
        System.out.println("Close.");
        this.writer.close();
    }
}

