/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.teolenn.output;

import fr.ens.transcriptome.teolenn.output.DefaultOutput;
import fr.ens.transcriptome.teolenn.output.FastaOutput;
import fr.ens.transcriptome.teolenn.output.GFFOutput;
import fr.ens.transcriptome.teolenn.output.Output;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class OutputRegistery {
    private static Logger logger = Logger.getLogger("Teolenn");
    private static Map<String, Class> registery = new HashMap<String, Class>();

    public static void addOutputType(String name, Class clazz) {
        if (name == null || clazz == null) {
            return;
        }
        if (OutputRegistery.testClassType(clazz)) {
            registery.put(name.toLowerCase(), clazz);
            logger.finest("Add " + name + " to Outputs registery");
        } else {
            logger.warning("Addon " + name + " is not a output class");
        }
    }

    public static void addOutputType(String name, String className) {
        if (name == null || "".equals(name) || className == null) {
            return;
        }
        try {
            Class<?> clazz = Class.forName(className);
            OutputRegistery.addOutputType(name, clazz);
            logger.info("Add external output: " + name);
        }
        catch (ClassNotFoundException e) {
            logger.severe("Cannot find " + className + " for " + name + " measurement addon");
            throw new RuntimeException("Cannot find " + className + " for " + name + " measurement addon");
        }
    }

    private static boolean testClassType(Class clazz) {
        if (clazz == null) {
            return false;
        }
        try {
            return clazz.newInstance() instanceof Output;
        }
        catch (InstantiationException e) {
            logger.severe("Can't create instance of " + clazz.getName() + ". Maybe your class doesn't have a void constructor.");
        }
        catch (IllegalAccessException e) {
            logger.severe("Can't access to " + clazz.getName());
        }
        return false;
    }

    public static Output getOutput(String name) {
        if (name == null) {
            return null;
        }
        Class clazz = registery.get(name.toLowerCase());
        if (clazz == null) {
            return null;
        }
        try {
            return (Output)clazz.newInstance();
        }
        catch (InstantiationException e) {
            System.err.println("Unable to instantiate " + name + " filter. Maybe this filter doesn't have a void constructor.");
            logger.severe("Unable to instantiate " + name + " filter. Maybe this filter doesn't have a void constructor.");
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    static {
        OutputRegistery.addOutputType("default", DefaultOutput.class);
        OutputRegistery.addOutputType("fasta", FastaOutput.class);
        OutputRegistery.addOutputType("gff", GFFOutput.class);
    }
}

