/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.teolenn.resource;

import fr.ens.transcriptome.teolenn.TeolennException;
import fr.ens.transcriptome.teolenn.resource.Resources;
import fr.ens.transcriptome.teolenn.util.FileUtils;
import fr.ens.transcriptome.teolenn.util.UnSynchronizedBufferedWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChromosomeNameResource {
    private static Logger logger = Logger.getLogger("Teolenn");
    public static final String RESOURCE_NAME = "chromosomes";
    private static final String CHROMOSOME_LIST_FILENAME = "chromosomes_list.txt";
    private static char[] FORBIDEN_CHARACTERS = new char[]{'!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '.', '/', ':', ';', '<', '=', '>', '?', '@', '[', '\\', ']', '^', '`', '{', '|', '}', '~'};
    private List<String> list = new ArrayList<String>();
    private Map<String, Integer> lengths = new HashMap<String, Integer>();
    private File listFile;

    public static ChromosomeNameResource getRessource() throws TeolennException {
        Resources rs = Resources.getResources();
        if (rs.isResource(RESOURCE_NAME)) {
            return (ChromosomeNameResource)rs.getResource(RESOURCE_NAME);
        }
        throw new TeolennException("Chromosomes names resource not initialized.");
    }

    public static ChromosomeNameResource getRessource(File oligoDirectory) {
        Resources rs = Resources.getResources();
        if (rs.isResource(RESOURCE_NAME)) {
            return (ChromosomeNameResource)rs.getResource(RESOURCE_NAME);
        }
        ChromosomeNameResource result = new ChromosomeNameResource();
        result.listFile = new File(oligoDirectory, CHROMOSOME_LIST_FILENAME);
        rs.setResource(RESOURCE_NAME, result);
        return result;
    }

    public void addChromosomesNames(Map<String, Integer> chromosomeNames) throws TeolennException {
        for (Map.Entry<String, Integer> e : chromosomeNames.entrySet()) {
            String nameTrimmed = e.getKey().trim();
            this.list.add(nameTrimmed);
            this.lengths.put(nameTrimmed, e.getValue());
        }
        logger.info("Chromosomes: " + this.list);
        String verifyError = this.verify();
        if (verifyError != null) {
            logger.severe(verifyError);
            throw new TeolennException(verifyError);
        }
        this.sortNames();
        this.save();
    }

    private void sortNames() {
        Collections.sort(this.list, new ChromosomeNameComparator());
    }

    public List<String> getChromosomesNames() {
        return Collections.unmodifiableList(this.list);
    }

    public int getChromosomeLength(String name) {
        if (this.lengths.containsKey(name)) {
            return this.lengths.get(name);
        }
        return 0;
    }

    private void save() {
        try {
            UnSynchronizedBufferedWriter bw = FileUtils.createBufferedWriter(this.listFile);
            StringBuilder sb = new StringBuilder();
            for (String s : this.list) {
                sb.append(s);
                sb.append('\t');
                sb.append(this.getChromosomeLength(s));
                sb.append('\n');
            }
            bw.write(sb.toString());
            bw.close();
        }
        catch (FileNotFoundException e) {
            logger.warning("Unable to create the file for chromosome names list.");
            return;
        }
        catch (IOException e) {
            logger.warning("Unable to create the file for chromosome names list.");
            return;
        }
    }

    private String verify() throws TeolennException {
        for (String chr : this.list) {
            if (chr.indexOf(32) != -1) {
                return "Invalid chromosome name. Not space is allowed: " + chr;
            }
            for (int i = 0; i < FORBIDEN_CHARACTERS.length; ++i) {
                if (chr.indexOf(FORBIDEN_CHARACTERS[i]) == -1) continue;
                return "Invalid chromosome name. The name contains one or more invalid character: " + chr;
            }
        }
        return null;
    }

    public void load() throws TeolennException {
        this.list.clear();
        try {
            BufferedReader br = FileUtils.createBufferedReader(this.listFile);
            String line = null;
            while ((line = br.readLine()) != null) {
                String trimmedLine = line.trim();
                int pos = trimmedLine.indexOf(9);
                String chr = trimmedLine.substring(0, pos - 1).trim();
                int len = Integer.parseInt(trimmedLine.substring(pos + 1));
                this.list.add(chr);
                this.lengths.put(chr, len);
            }
            br.close();
            this.sortNames();
        }
        catch (FileNotFoundException e) {
            throw new TeolennException("Unable to load the list of chromosomes names.");
        }
        catch (IOException e) {
            throw new TeolennException("Unable to load the list of chromosomes names.");
        }
        String verifyError = this.verify();
        if (verifyError != null) {
            logger.severe(verifyError);
            throw new TeolennException(verifyError);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ChromosomeNameComparator
    implements Comparator<String> {
        private ChromosomeNameComparator() {
        }

        @Override
        public int compare(String a, String b) {
            String prefixB;
            int lastB;
            if (a == null && b == null) {
                return 0;
            }
            if (a == null) {
                return -1;
            }
            if (b == null) {
                return 1;
            }
            if (a.equals(b)) {
                return 0;
            }
            int lastA = this.getLastDigitIndex(a);
            if (lastA != (lastB = this.getLastDigitIndex(b))) {
                return a.compareTo(b);
            }
            String prefixA = a.substring(0, lastA);
            if (!prefixA.equals(prefixB = b.substring(0, lastB))) {
                return prefixA.compareTo(prefixB);
            }
            String suffixA = a.substring(lastA, a.length());
            String suffixB = b.substring(lastB, b.length());
            int nA = suffixA.length() == 0 ? 0 : Integer.parseInt(suffixA);
            int nB = suffixB.length() == 0 ? 0 : Integer.parseInt(suffixB);
            return nA - nB;
        }

        private int getLastDigitIndex(String a) {
            for (int i = a.length(); i > 0; --i) {
                if (Character.isDigit(a.charAt(i - 1))) continue;
                return i;
            }
            return 0;
        }
    }
}

