/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.teolenn.resource;

import fr.ens.transcriptome.teolenn.resource.Resources;
import fr.ens.transcriptome.teolenn.util.FileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ORFResource {
    public static final String RESOURCE_NAME = "orf";
    private static Logger logger = Logger.getLogger("Teolenn");
    private static final Pattern seqNamePattern = Pattern.compile("^(.+)\t(\\d+)\t(\\d+)$");
    private Map<String, Set<ORF>> orfs = new HashMap<String, Set<ORF>>();
    private final Set<ORF> orfsToRemove = new HashSet<ORF>();
    private Set<ORF> lastOrfsChr = null;
    private Set<ORF> currentChrORFs = null;
    private Set<String> unknownChromosomes = null;
    private String currentSequenceName;
    private ORF currentORF;
    private List<ORF> currentORFs;
    private String lastChromosome;
    private int lastOligoStart;

    public static ORFResource getRessource(Properties properties) throws IOException {
        int oligoStart1;
        Resources rs = Resources.getResources();
        if (rs.isResource(RESOURCE_NAME)) {
            return (ORFResource)rs.getResource(RESOURCE_NAME);
        }
        if (!properties.containsKey("orfsfile")) {
            throw new IOException("No orfsFile");
        }
        File orfsFile = new File(properties.getProperty("orfsfile"));
        int n = oligoStart1 = Boolean.parseBoolean(properties.getProperty("_start1")) ? 1 : 0;
        int orfStart1 = properties.containsKey("start1") ? (Boolean.parseBoolean(properties.getProperty("start1")) ? 1 : 0) : 0;
        int startOffset = 0;
        startOffset = oligoStart1 == orfStart1 ? 0 : oligoStart1 - orfStart1;
        ORFResource result = new ORFResource(orfsFile, startOffset);
        rs.setResource(RESOURCE_NAME, result);
        return result;
    }

    public ORF getORF(String chromosome, int oligoStart, int oligoLength) {
        if (this.lastChromosome == chromosome && this.lastOligoStart == oligoStart) {
            return this.currentORF;
        }
        this.lastChromosome = chromosome;
        this.lastOligoStart = oligoStart;
        return this.getORF(chromosome + "\t" + oligoStart + "\t" + oligoLength);
    }

    private final ORF getORF(String sequenceKey) {
        if (sequenceKey == null) {
            return null;
        }
        if (sequenceKey.equals(this.currentSequenceName)) {
            return this.currentORF;
        }
        ORF orf = this.nextORF(sequenceKey);
        this.currentSequenceName = sequenceKey;
        this.currentORF = orf;
        return orf;
    }

    private final ORF nextORF(String sequenceKey) {
        if (sequenceKey == null) {
            return null;
        }
        Matcher m = seqNamePattern.matcher(sequenceKey);
        if (!m.matches()) {
            throw new RuntimeException("Unable to parse sequence name: " + sequenceKey);
        }
        String chr = m.group(1);
        int start = Integer.parseInt(m.group(2));
        int len = Integer.parseInt(m.group(3));
        int end = start + len;
        Set<ORF> chrORFs = this.orfs.get(chr);
        if (chrORFs == null) {
            if (this.unknownChromosomes == null) {
                this.unknownChromosomes = new HashSet<String>();
            }
            if (!this.unknownChromosomes.contains(chr)) {
                this.unknownChromosomes.add(chr);
                logger.warning("Unknown chromosome in annotation: " + chr);
            }
            return null;
        }
        if (chrORFs != this.lastOrfsChr) {
            this.lastOrfsChr = chrORFs;
            this.currentChrORFs = new TreeSet<ORF>(chrORFs);
        }
        this.orfsToRemove.clear();
        for (ORF o : this.currentChrORFs) {
            if (end > o.end) {
                this.orfsToRemove.add(o);
                continue;
            }
            if (!o.isOligoInsideORF(start, end)) continue;
            return o;
        }
        return null;
    }

    public List<ORF> getORFs(String chromosome, int oligoStart, int oligoLength) {
        if (this.lastChromosome == chromosome && this.lastOligoStart == oligoStart) {
            return this.currentORFs;
        }
        this.lastChromosome = chromosome;
        this.lastOligoStart = oligoStart;
        return this.getORFs(chromosome + "\t" + oligoStart + "\t" + oligoLength);
    }

    private final List<ORF> getORFs(String sequenceKey) {
        if (sequenceKey == null) {
            return null;
        }
        if (sequenceKey.equals(this.currentSequenceName)) {
            return this.currentORFs;
        }
        List<ORF> orfs = this.nextORFs(sequenceKey);
        this.currentSequenceName = sequenceKey;
        this.currentORFs = orfs;
        return orfs;
    }

    private final List<ORF> nextORFs(String sequenceKey) {
        if (sequenceKey == null) {
            return null;
        }
        Matcher m = seqNamePattern.matcher(sequenceKey);
        if (!m.matches()) {
            throw new RuntimeException("Unable to parse sequence name: " + sequenceKey);
        }
        String chr = m.group(1);
        int start = Integer.parseInt(m.group(2));
        int len = Integer.parseInt(m.group(3));
        int end = start + len;
        Set<ORF> chrORFs = this.orfs.get(chr);
        if (chrORFs == null) {
            if (this.unknownChromosomes == null) {
                this.unknownChromosomes = new HashSet<String>();
            }
            if (!this.unknownChromosomes.contains(chr)) {
                this.unknownChromosomes.add(chr);
                logger.warning("Unknown chromosome in annotation: " + chr);
            }
            return null;
        }
        if (chrORFs != this.lastOrfsChr) {
            this.lastOrfsChr = chrORFs;
            this.currentChrORFs = new TreeSet<ORF>(chrORFs);
        }
        ArrayList<ORF> result = new ArrayList<ORF>();
        for (ORF o : this.currentChrORFs) {
            if (!o.isOligoInsideORF(start, end)) continue;
            result.add(o);
        }
        return result.size() > 0 ? result : null;
    }

    private ORFResource(File orfsFile, int startOffset) throws IOException {
        BufferedReader br = FileUtils.createBufferedReader(orfsFile);
        Pattern p = Pattern.compile("\t");
        String line = null;
        while ((line = br.readLine()) != null) {
            Set<Object> chrORFs;
            String lineTrimed;
            if (line.startsWith("#") || "".equals(lineTrimed = line.trim())) continue;
            String[] fields = p.split(lineTrimed);
            String orfName = fields[0];
            String chr = fields[1];
            String location = fields[2];
            int posSeparator = location.indexOf(58);
            boolean codingStrand = Integer.parseInt(fields[3]) == 1;
            int start = Integer.parseInt(location.substring(1, posSeparator)) + startOffset;
            int end = Integer.parseInt(location.substring(posSeparator + 1, location.length() - 1)) + startOffset;
            if (!this.orfs.containsKey(chr)) {
                chrORFs = new TreeSet();
                this.orfs.put(chr, chrORFs);
            } else {
                chrORFs = this.orfs.get(chr);
            }
            chrORFs.add(new ORF(chr, start, end, orfName, codingStrand));
        }
        int count = 0;
        for (String k : this.orfs.keySet()) {
            count += this.orfs.get(k).size();
        }
        logger.fine("Orfs readed: " + count);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ORF
    implements Comparable<ORF> {
        public String name;
        public String chromosome;
        public int start;
        public int end;
        public boolean codingStrand;

        public final boolean isOligoInsideORF(int start, int end) {
            return start >= this.start && end <= this.end;
        }

        @Override
        public final int compareTo(ORF orf) {
            return this.start - orf.start;
        }

        public String toString() {
            return this.name + " " + this.chromosome + " [" + this.start + "-" + this.end + "]" + (this.codingStrand ? "+1" : "-1");
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || !(o instanceof ORF)) {
                return false;
            }
            ORF orf = (ORF)o;
            return this.name.equals(orf.name) && this.start == orf.start && this.end == orf.end && this.codingStrand == orf.codingStrand;
        }

        public ORF(String chromosome, int start, int end, String name, boolean codingStrand) {
            this.chromosome = chromosome;
            this.start = start;
            this.end = end;
            this.name = name;
            this.codingStrand = codingStrand;
        }
    }
}

