/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.teolenn.resource;

import fr.ens.transcriptome.teolenn.TeolennException;
import fr.ens.transcriptome.teolenn.resource.ChromosomeNameResource;
import fr.ens.transcriptome.teolenn.resource.Resources;
import fr.ens.transcriptome.teolenn.sequence.Sequence;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class OligoSequenceResource {
    public static final String RESOURCE_NAME = "oligo";
    private static final String CHARSET = "ISO-8859-1";
    private File oligosDir;
    private String chr;
    private int chrLength = -1;
    private String oligosExtension;
    private int oligoLength;
    private int oligoIntervalLength;
    private boolean start1;
    private int positionConstant;
    private FileChannel inChannel;
    private ByteBuffer bb;

    public Sequence getSequence(String chr, int oligoStartPos, int oligoLength) throws IOException, TeolennException {
        return this.getSequence(chr, oligoStartPos, oligoLength, null);
    }

    public Sequence getSequence(String chromosome, int oligoStartPos, int oligoLength, Sequence sequence) throws IOException, TeolennException {
        if (chromosome == null || oligoStartPos < 0) {
            return null;
        }
        if (!chromosome.equals(this.chr)) {
            if (this.inChannel != null) {
                this.inChannel.close();
            }
            this.chr = chromosome;
            File f = new File(this.oligosDir, chromosome + this.oligosExtension);
            FileInputStream fis = new FileInputStream(f);
            this.inChannel = fis.getChannel();
            this.positionConstant = this.calcPositionConstant();
            this.chrLength = ChromosomeNameResource.getRessource().getChromosomeLength(chromosome);
        }
        if (this.chrLength == -1) {
            throw new TeolennException("Chromosome length not found.");
        }
        long pos = this.getFilePos(oligoStartPos, oligoLength, this.start1);
        int length = this.positionConstant + OligoSequenceResource.getDigits(oligoStartPos) + oligoLength;
        if (this.bb == null || this.bb.capacity() != length) {
            this.bb = ByteBuffer.allocate(length);
        } else {
            this.bb.clear();
        }
        int read = this.inChannel.read(this.bb, pos);
        if (read != length) {
            throw new TeolennException("Error while reading sequence " + chromosome + "," + oligoStartPos + ". pos=" + pos + " oligolengtg=" + oligoLength + " len=" + length + " read=" + read + " bb.capacity=" + this.bb.capacity());
        }
        return OligoSequenceResource.string2Sequence(new String(this.bb.array(), CHARSET), sequence);
    }

    private static final Sequence string2Sequence(String s, Sequence sequence) {
        Sequence result = sequence == null ? new Sequence() : sequence;
        int i1 = s.indexOf(10);
        if (i1 == -1) {
            return null;
        }
        int i2 = s.indexOf(10, i1 + 1);
        if (i2 == -1) {
            return null;
        }
        result.setName(s.substring(1, i1));
        result.setSequence(s.substring(i1 + 1, i2));
        return result;
    }

    public void close() throws IOException {
        if (this.inChannel == null) {
            return;
        }
        this.inChannel.close();
        this.inChannel = null;
    }

    private int calcPositionConstant() {
        return 5 + this.chr.length() + ":subseq(".length() + OligoSequenceResource.getDigits(this.oligoLength);
    }

    private static final long calcPositionVariableHeader(int oligoStartPos, boolean start1) {
        long count = start1 ? 9L : 10L;
        long toAdd = 9L;
        long sumToAdd = 10L;
        int digits = OligoSequenceResource.getDigits(oligoStartPos);
        if (digits == 1) {
            return oligoStartPos;
        }
        for (int j = 2; j < digits; ++j) {
            count += (toAdd *= 10L) * (long)j;
            sumToAdd += toAdd;
        }
        return count += ((long)oligoStartPos - sumToAdd) * (long)digits;
    }

    private long getFilePos(int oligoStartPos, int currentOligoLength, boolean start1) {
        int maxStdPos = this.chrLength - this.oligoLength - this.oligoIntervalLength;
        int repeats = 1 + this.oligoIntervalLength * 2;
        if (oligoStartPos <= maxStdPos) {
            int previousPositions = start1 ? oligoStartPos - 1 : oligoStartPos;
            long previousHeaderVariable = OligoSequenceResource.calcPositionVariableHeader(oligoStartPos, start1);
            long result = ((long)(previousPositions * (this.positionConstant + this.oligoLength)) + previousHeaderVariable) * (long)repeats;
            for (int i = this.oligoLength - this.oligoIntervalLength; i < currentOligoLength; ++i) {
                result += (long)(this.positionConstant + OligoSequenceResource.getDigits(oligoStartPos) + i);
            }
            return result;
        }
        int previousPositions = start1 ? maxStdPos : maxStdPos + 1;
        long previousHeaderVariable = OligoSequenceResource.calcPositionVariableHeader(previousPositions, start1);
        long result = ((long)((start1 ? previousPositions - 1 : previousPositions) * (this.positionConstant + this.oligoLength)) + previousHeaderVariable) * (long)repeats;
        for (int i = previousPositions; i <= oligoStartPos; ++i) {
            int max = i == oligoStartPos ? currentOligoLength + this.oligoIntervalLength - this.oligoLength : this.chrLength - this.oligoLength + this.oligoIntervalLength - i + 1;
            for (int j = 0; j < max; ++j) {
                result += (long)(this.positionConstant + OligoSequenceResource.getDigits(i) + this.oligoLength - this.oligoIntervalLength + j);
            }
        }
        return result;
    }

    private static final int getDigits(int n) {
        int count = 1;
        for (int val = 10; n >= val; val *= 10) {
            ++count;
        }
        return count;
    }

    public static OligoSequenceResource getRessource() throws TeolennException {
        Resources rs = Resources.getResources();
        if (rs.isResource(RESOURCE_NAME)) {
            return (OligoSequenceResource)rs.getResource(RESOURCE_NAME);
        }
        throw new TeolennException("OligoSequenceResource has not been initialized.");
    }

    public static OligoSequenceResource getRessource(File oligosDir, String extension, int oligoLength, int oligoIntervalLength, boolean start1) throws TeolennException {
        Resources rs = Resources.getResources();
        if (rs.isResource(RESOURCE_NAME)) {
            return (OligoSequenceResource)rs.getResource(RESOURCE_NAME);
        }
        OligoSequenceResource result = new OligoSequenceResource(oligosDir, extension, oligoLength, oligoIntervalLength, start1);
        rs.setResource(RESOURCE_NAME, result);
        return result;
    }

    private OligoSequenceResource(File oligosDir, String extension, int oligoLength, int oligoIntervalLength, boolean start1) throws TeolennException {
        if (oligosDir == null) {
            throw new TeolennException("Invalid directory for oligonucleotides: " + oligosDir);
        }
        if (extension == null) {
            throw new TeolennException("Invalid extension for oligonucleotides: " + this.oligosExtension);
        }
        if (oligoLength < 0) {
            throw new TeolennException("Invalid length for oligonucleotides: " + oligoLength);
        }
        if (oligoIntervalLength < 0) {
            throw new TeolennException("Invalid interval length for oligonucleotides: " + oligoIntervalLength);
        }
        this.oligosDir = oligosDir;
        this.oligosExtension = extension;
        this.oligoLength = oligoLength;
        this.oligoIntervalLength = oligoIntervalLength;
        this.start1 = start1;
    }
}

