/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.teolenn.selector;

import fr.ens.transcriptome.teolenn.resource.ORFResource;
import fr.ens.transcriptome.teolenn.selector.SimpleSelectorMeasurement;

public class From5PrimeORFMeasurement
extends SimpleSelectorMeasurement {
    public static final String MEASUREMENT_NAME = "from5primeorf";
    private ORFResource ressource;
    private int oligoLength;
    private float coef;
    private int maxNotNull = 2000;
    private boolean first = true;

    public Object calcMesurement(String chromosome, int startPos, int oligoLength) {
        ORFResource.ORF orf = this.ressource.getORF(chromosome, startPos, oligoLength);
        if (orf == null) {
            return -1;
        }
        if (!orf.codingStrand) {
            return startPos - orf.start;
        }
        return orf.end - startPos - this.oligoLength;
    }

    public String getName() {
        return MEASUREMENT_NAME;
    }

    public String getDescription() {
        return "Get the distance from the start of the orf";
    }

    public Object getType() {
        return Integer.class;
    }

    public Object parse(String s) {
        if (s == null) {
            return null;
        }
        return Integer.parseInt(s);
    }

    public float getScore(Object value) {
        int pos = (Integer)value;
        if (pos < 0) {
            return 0.0f;
        }
        if (this.first) {
            this.coef = -1.0f / (float)this.maxNotNull;
            this.first = false;
        }
        return this.coef * (float)pos - 1.0f;
    }

    public void setInitParameter(String key, String value) {
        if ("maxposwithout0score".equals(key)) {
            this.maxNotNull = Integer.parseInt(value);
        }
    }

    public void init() {
    }

    public From5PrimeORFMeasurement() {
    }

    public From5PrimeORFMeasurement(ORFResource ressource, int oligoLength) {
        this.ressource = ressource;
        this.oligoLength = oligoLength;
    }
}

