/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.teolenn.selector;

import fr.ens.transcriptome.teolenn.selector.SimpleSelectorMeasurement;

public final class PositionMeasurement
extends SimpleSelectorMeasurement {
    public static final String MEASUREMENT_NAME = "Position";
    private boolean start1;
    private int windowLength = -1;
    private int windowBestPosition;
    private boolean first = true;

    public Object calcMesurement(String chromosome, int startPos, int oligoLength) {
        if (this.windowLength == -1) {
            throw new RuntimeException("Window size is undefined.");
        }
        if (this.first) {
            this.windowBestPosition = (int)Math.ceil((float)(this.windowLength - oligoLength) / 2.0f);
            this.first = false;
        }
        int internalStartPos = this.start1 ? startPos - 1 : startPos;
        int windowStart = (int)(Math.floor((float)internalStartPos / (float)this.windowLength) * (double)this.windowLength - 1.0);
        int oligo2Window = internalStartPos - windowStart;
        float result = 1.0f - (float)Math.abs(this.windowBestPosition - oligo2Window) / ((float)this.windowLength - (float)this.windowBestPosition);
        return Float.valueOf(result);
    }

    public String getName() {
        return MEASUREMENT_NAME;
    }

    public String getDescription() {
        return "Get a position score for the sequence";
    }

    public Object getType() {
        return Float.class;
    }

    public Object parse(String s) {
        if (s == null) {
            return null;
        }
        return Float.valueOf(Float.parseFloat(s));
    }

    public float getScore(Object value) {
        return ((Float)value).floatValue();
    }

    public void setInitParameter(String key, String value) {
    }

    public void init() {
    }

    public PositionMeasurement() {
    }

    public PositionMeasurement(boolean start1, int windowSize) {
        this.start1 = start1;
        this.windowLength = windowSize;
    }
}

