/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.teolenn.selector;

import fr.ens.transcriptome.teolenn.selector.SequenceSelector;
import fr.ens.transcriptome.teolenn.selector.TilingSelector;
import fr.ens.transcriptome.teolenn.selector.TilingZoneSelector;
import fr.ens.transcriptome.teolenn.selector.ZoneSelector;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class SequenceSelectorRegistery {
    private static Logger logger = Logger.getLogger("Teolenn");
    private static Map<String, Class> registery = new HashMap<String, Class>();

    public static void addSequenceSelectorType(String name, Class clazz) {
        if (name == null || clazz == null) {
            return;
        }
        String lowerName = name.toLowerCase();
        if (registery.containsKey(lowerName)) {
            logger.warning("Selector " + name + " already exits, override previous selector.");
        }
        registery.put(lowerName, clazz);
    }

    public static void addSequenceSelectorType(String name, String className) {
        if (name == null || "".equals(name) || className == null) {
            return;
        }
        try {
            Class<?> clazz = Class.forName(className);
            SequenceSelectorRegistery.addSequenceSelectorType(name.toLowerCase(), clazz);
            logger.info("Add external selector: " + name);
        }
        catch (ClassNotFoundException e) {
            logger.severe("Cannot find " + className + " for " + name + " selector addon");
            throw new RuntimeException("Cannot find " + className + " for " + name + " selector addon");
        }
    }

    private static boolean testClassType(Class clazz) {
        if (clazz == null) {
            return false;
        }
        try {
            return clazz.newInstance() instanceof SequenceSelector;
        }
        catch (InstantiationException e) {
            logger.severe("Can't create instance of " + clazz.getName() + ". Maybe your class doesn't have a void constructor.");
        }
        catch (IllegalAccessException e) {
            logger.severe("Can't access to " + clazz.getName());
        }
        return false;
    }

    public static SequenceSelector getSequenceSelector(String name) {
        if (name == null) {
            return null;
        }
        Class clazz = registery.get(name.toLowerCase());
        if (clazz == null) {
            return null;
        }
        try {
            return (SequenceSelector)clazz.newInstance();
        }
        catch (InstantiationException e) {
            System.err.println("Unable to instantiate " + name + " filter. Maybe this filter doesn't have a void constructor.");
            logger.severe("Unable to instantiate " + name + " filter. Maybe this filter doesn't have a void constructor.");
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    static {
        SequenceSelectorRegistery.addSequenceSelectorType("tiling", TilingSelector.class);
        SequenceSelectorRegistery.addSequenceSelectorType("zone", ZoneSelector.class);
        SequenceSelectorRegistery.addSequenceSelectorType("tilingzone", TilingZoneSelector.class);
    }
}

