/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.teolenn.selector;

import fr.ens.transcriptome.teolenn.TeolennException;
import fr.ens.transcriptome.teolenn.WeightsSetter;
import fr.ens.transcriptome.teolenn.measurement.Measurement;
import fr.ens.transcriptome.teolenn.measurement.io.SequenceMeasurementsReader;
import fr.ens.transcriptome.teolenn.measurement.io.SequenceMeasurementsWriter;
import fr.ens.transcriptome.teolenn.selector.GlobalScoreMeasurement;
import fr.ens.transcriptome.teolenn.selector.SelectorMeasurement;
import fr.ens.transcriptome.teolenn.selector.SequenceSelector;
import fr.ens.transcriptome.teolenn.sequence.SequenceMeasurements;
import fr.ens.transcriptome.teolenn.sequence.SequenceMeasurementsStatReader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public abstract class SimpleSelector
implements SequenceSelector {
    private static Logger logger = Logger.getLogger("Teolenn");
    private List<SelectorMeasurement> ms = new ArrayList<SelectorMeasurement>();
    private SequenceMeasurementsReader measurementReader;
    private SequenceMeasurementsWriter measurementWriter;
    private File statsFile;
    private SequenceMeasurements smReaded;
    private SequenceMeasurements smWrited;
    private int smReadedLength;
    private Object[] smReadedValues;
    private WeightsSetter weightsSetters;
    private int indexScaffold = -1;
    private int indexStartPosition = -1;
    private int indexOligoLengthPosition = -1;
    private int indexFirstSelectorMeasurement = 0;
    private Object[] valuesToWrite;
    private boolean first = true;

    public abstract void doSelection() throws IOException;

    public void setInitParameter(String key, String value) {
        if ("_statsFile".equals(key)) {
            this.statsFile = new File(value);
        }
    }

    public void addMeasurement(SelectorMeasurement measurement) {
        if (measurement != null) {
            this.ms.add(measurement);
        }
    }

    public void select(SequenceMeasurementsReader measurementReader, SequenceMeasurementsWriter measurementWriter, WeightsSetter weightsSetters) throws TeolennException {
        if (measurementReader == null) {
            throw new TeolennException("No measurement reader defined for selector");
        }
        if (measurementWriter == null) {
            throw new TeolennException("No measurement writer defined for selector");
        }
        if (weightsSetters == null) {
            throw new TeolennException("No weights defined for selector");
        }
        this.measurementReader = measurementReader;
        this.measurementWriter = measurementWriter;
        this.weightsSetters = weightsSetters;
        try {
            this.doSelection();
        }
        catch (IOException e) {
            throw new TeolennException(e);
        }
    }

    public SequenceMeasurements next() throws IOException {
        this.smReaded = this.measurementReader.next(this.smReaded);
        SequenceMeasurements smReaded = this.smReaded;
        if (smReaded == null) {
            return null;
        }
        if (this.first) {
            this.smReadedValues = smReaded.getArrayMeasurementValues();
            this.smReadedLength = smReaded.size();
            this.indexScaffold = smReaded.getIndexMeasurment("Chromosome");
            this.indexStartPosition = smReaded.getIndexMeasurment("OligoStart");
            this.indexOligoLengthPosition = smReaded.getIndexMeasurment("OligoLength");
            this.smWrited = new SequenceMeasurements();
            for (Measurement measurement : smReaded.getMeasurements()) {
                this.smWrited.addMesurement(measurement);
                ++this.indexFirstSelectorMeasurement;
            }
            for (SelectorMeasurement selectorMeasurement : this.ms) {
                this.smWrited.addMesurement(selectorMeasurement);
            }
            this.smWrited.addMesurement(new GlobalScoreMeasurement());
            this.valuesToWrite = new Object[this.smReadedLength + this.ms.size() + 1];
            this.smWrited.setArrayMeasurementValues(this.valuesToWrite);
            SequenceMeasurementsStatReader smsr = new SequenceMeasurementsStatReader(this.statsFile, smReaded);
            smsr.read();
            this.weightsSetters.setWeights(this.smWrited);
            if (this.smWrited.isSumOfWeightEquals1()) {
                logger.warning("Sum of weights is not equals to 1.");
            }
            this.first = false;
        }
        String chromosome = (String)this.smReadedValues[this.indexScaffold];
        int n = (Integer)this.smReadedValues[this.indexStartPosition];
        int oligoLength = (Integer)this.smReadedValues[this.indexOligoLengthPosition];
        System.arraycopy(this.smReadedValues, 0, this.valuesToWrite, 0, this.smReadedLength);
        int i = this.smReadedLength;
        for (SelectorMeasurement m : this.ms) {
            this.valuesToWrite[i++] = m.calcMesurement(chromosome, n, oligoLength);
        }
        this.valuesToWrite[i++] = Float.valueOf(this.smWrited.getScore());
        this.smWrited.setId(smReaded.getId());
        return this.smWrited;
    }

    public void writeSelectedSequenceMeasurements(SequenceMeasurements sm) throws IOException {
        this.measurementWriter.writeSequenceMesurement(sm);
    }

    public void close() throws IOException {
        this.measurementReader.close();
        this.measurementWriter.close();
    }
}

