/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.teolenn.selector;

import fr.ens.transcriptome.teolenn.measurement.SimpleMeasurement;
import fr.ens.transcriptome.teolenn.selector.SelectorMeasurement;
import fr.ens.transcriptome.teolenn.sequence.Sequence;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class SimpleSelectorMeasurement
extends SimpleMeasurement
implements SelectorMeasurement {
    private static final Pattern seqNamePattern = Pattern.compile("^(.*):subseq\\((\\d+),(\\d+)\\)$");

    public final Object calcMesurement(Sequence sequence) {
        String sequenceName = sequence.getName();
        Matcher m = seqNamePattern.matcher(sequenceName);
        if (!m.matches()) {
            throw new RuntimeException("Unable to parse sequence name: " + sequenceName);
        }
        String chr = m.group(1);
        int startPos = Integer.parseInt(m.group(2));
        int len = sequence.getLengthOligo();
        return this.calcMesurement(chr, startPos, len);
    }
}

