/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.teolenn.selector;

import fr.ens.transcriptome.teolenn.TeolennException;
import fr.ens.transcriptome.teolenn.measurement.Measurement;
import fr.ens.transcriptome.teolenn.selector.PositionMeasurement;
import fr.ens.transcriptome.teolenn.selector.SimpleSelector;
import fr.ens.transcriptome.teolenn.selector.TilingZoneMeasurement;
import fr.ens.transcriptome.teolenn.sequence.SequenceMeasurements;
import java.io.IOException;
import java.util.logging.Logger;

public class TilingSelector
extends SimpleSelector {
    private static Logger logger = Logger.getLogger("Teolenn");
    public static final String SELECTOR_NAME = "tiling";
    private static final float MIN_SCORE = -3.4028235E38f;
    private boolean start1;
    private int oligoLength;
    private int windowLength = -1;
    private int windowStep = -1;

    public String getName() {
        return SELECTOR_NAME;
    }

    public String getDescription() {
        return "A Selector for tiling design";
    }

    public void setInitParameter(String key, String value) {
        if ("_start1".equals(key)) {
            this.start1 = Boolean.parseBoolean(value);
        } else if ("_oligolength".equals(key)) {
            this.oligoLength = Integer.parseInt(value.trim());
        } else if ("windowlength".equals(key)) {
            this.windowLength = Integer.parseInt(value.trim());
        } else if ("windowstep".equals(key)) {
            this.windowStep = Integer.parseInt(value.trim());
        }
        super.setInitParameter(key, value);
    }

    public void init() throws TeolennException {
        if (this.windowLength < 1) {
            throw new TeolennException("Invalid window length: " + this.windowLength);
        }
        if (this.windowStep == -1) {
            this.windowStep = this.windowLength;
        } else if (this.windowStep < 1) {
            throw new TeolennException("Invalid window step: " + this.windowStep);
        }
        this.addMeasurement(new PositionMeasurement(this.start1, this.windowLength));
        this.addMeasurement(new TilingZoneMeasurement());
    }

    public void doSelection() throws IOException {
        logger.info("TilingSelector, windowLength=" + this.windowLength);
        logger.info("TilingSelector, windowStep=" + this.windowStep);
        logger.finest("TilingSelector, start1=" + this.start1);
        logger.finest("TilingSelector, oligoLength=" + this.oligoLength);
        boolean first = true;
        int indexScaffold = -1;
        int indexStartPosition = -1;
        int indexOligoLengthPosition = -1;
        int indexTilingZoneMeasurement = -1;
        String currentScafold = null;
        int infoLastIndexStartPosition = -1;
        int infoCountWindows = 1;
        int infoCountSelectedOligos = 0;
        int windowLength = this.windowLength;
        int endWindow = windowLength - 1 + (this.start1 ? 1 : 0);
        int startWindow = this.start1 ? 1 : 0;
        String tilingZone = "[" + startWindow + "-" + endWindow + "]";
        float bestScore = -3.4028235E38f;
        float nextBestScore = -3.4028235E38f;
        int posNextBestScore = -1;
        int lastSelected = -1;
        int valuesLength = -1;
        SequenceMeasurements sm = null;
        Object[] values = null;
        SequenceMeasurements smToWrite = new SequenceMeasurements();
        SequenceMeasurements nextSmToWrite = new SequenceMeasurements();
        while ((sm = this.next()) != null) {
            Object[] valuesToWrite;
            if (first) {
                indexScaffold = sm.getIndexMeasurment("Chromosome");
                indexStartPosition = sm.getIndexMeasurment("OligoStart");
                indexOligoLengthPosition = sm.getIndexMeasurment("OligoLength");
                indexTilingZoneMeasurement = sm.getIndexMeasurment("TilingZone");
                values = sm.getArrayMeasurementValues();
                for (Measurement m : sm.getMeasurements()) {
                    smToWrite.addMesurement(m);
                    nextSmToWrite.addMesurement(m);
                }
                valuesLength = values.length;
                first = false;
            }
            if (indexScaffold < 0) {
                throw new RuntimeException("No Scaffold field");
            }
            if (indexStartPosition < 0) {
                throw new RuntimeException("No Start field");
            }
            if (indexOligoLengthPosition < 0) {
                throw new RuntimeException("No oligo length field");
            }
            String chromosome = (String)values[indexScaffold];
            int pos = (Integer)values[indexStartPosition];
            int id = sm.getId();
            if (currentScafold == null) {
                currentScafold = chromosome;
            }
            if (!currentScafold.equals(chromosome)) {
                if (bestScore > -3.4028235E38f) {
                    if (lastSelected != smToWrite.getId()) {
                        this.writeSelectedSequenceMeasurements(smToWrite);
                        lastSelected = smToWrite.getId();
                        ++infoCountSelectedOligos;
                    }
                } else {
                    logger.severe("Bad case while selecting (1): " + bestScore);
                }
                logger.fine(String.format("chromosome: %s\t%d windows (%.2f theoric), %d oligos selected, %d pb in chromosome, %d pb windows, %d pb step.", currentScafold, infoCountWindows, Float.valueOf(((float)infoLastIndexStartPosition + 1.0f - (float)windowLength) / (float)this.windowStep + 1.0f), infoCountSelectedOligos, infoLastIndexStartPosition, windowLength, this.windowStep));
                infoCountSelectedOligos = 0;
                currentScafold = chromosome;
                endWindow = windowLength - 1 + (this.start1 ? 1 : 0);
                startWindow = this.start1 ? 1 : 0;
                infoCountWindows = 1;
                while (pos >= endWindow) {
                    startWindow = endWindow + 1;
                    endWindow += this.windowStep;
                    ++infoCountWindows;
                }
                tilingZone = "[" + startWindow + "-" + endWindow + "]";
                bestScore = -3.4028235E38f;
                nextBestScore = -3.4028235E38f;
                posNextBestScore = -1;
            }
            if (pos >= endWindow) {
                if (bestScore > -3.4028235E38f) {
                    if (lastSelected != smToWrite.getId()) {
                        this.writeSelectedSequenceMeasurements(smToWrite);
                        lastSelected = smToWrite.getId();
                        ++infoCountSelectedOligos;
                    }
                } else {
                    logger.severe("Bad case while selecting (2): " + bestScore);
                }
                bestScore = -3.4028235E38f;
                int previousEndWindow = endWindow;
                while (pos >= endWindow) {
                    startWindow = endWindow + 1;
                    endWindow += this.windowStep;
                    ++infoCountWindows;
                }
                tilingZone = "[" + startWindow + "-" + endWindow + "]";
                if (endWindow - this.windowStep == previousEndWindow) {
                    bestScore = nextBestScore;
                    if (posNextBestScore < startWindow + this.windowStep) {
                        nextBestScore = -3.4028235E38f;
                    }
                }
            }
            float score = sm.getScore();
            boolean bestScoreChanged = false;
            if (score > bestScore) {
                bestScore = score;
                smToWrite.setId(id);
                values[indexTilingZoneMeasurement] = tilingZone;
                valuesToWrite = new Object[valuesLength];
                System.arraycopy(values, 0, valuesToWrite, 0, valuesLength);
                smToWrite.setArrayMeasurementValues(valuesToWrite);
                bestScoreChanged = true;
            }
            if (pos >= startWindow + this.windowStep && score > nextBestScore) {
                nextBestScore = score;
                posNextBestScore = pos;
                nextSmToWrite.setId(id);
                if (bestScoreChanged) {
                    nextSmToWrite.setArrayMeasurementValues(smToWrite.getArrayMeasurementValues());
                } else {
                    values[indexTilingZoneMeasurement] = tilingZone;
                    valuesToWrite = new Object[valuesLength];
                    System.arraycopy(values, 0, valuesToWrite, 0, valuesLength);
                    nextSmToWrite.setArrayMeasurementValues(valuesToWrite);
                }
            }
            infoLastIndexStartPosition = pos;
        }
        if (bestScore > -3.4028235E38f && lastSelected != smToWrite.getId()) {
            this.writeSelectedSequenceMeasurements(smToWrite);
        }
        logger.fine(String.format("chromosome: %s\t%d windows (%.2f theoric), %d oligos selected, %d pb in chromosome, %d pb windows, %d pb step.", currentScafold, infoCountWindows, Float.valueOf((float)infoLastIndexStartPosition / (float)windowLength), infoCountSelectedOligos, infoLastIndexStartPosition, windowLength, this.windowStep));
        this.close();
    }
}

