/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.teolenn.selector;

import fr.ens.transcriptome.teolenn.TeolennException;
import fr.ens.transcriptome.teolenn.measurement.Measurement;
import fr.ens.transcriptome.teolenn.resource.ORFResource;
import fr.ens.transcriptome.teolenn.selector.From5PrimeORFMeasurement;
import fr.ens.transcriptome.teolenn.selector.FromEndORFMeasurement;
import fr.ens.transcriptome.teolenn.selector.FromStartORFMeasurement;
import fr.ens.transcriptome.teolenn.selector.ORFMeasurement;
import fr.ens.transcriptome.teolenn.selector.SimpleSelector;
import fr.ens.transcriptome.teolenn.sequence.SequenceMeasurements;
import java.io.IOException;
import java.util.Properties;

public class ZoneSelector
extends SimpleSelector {
    private static final float MIN_SCORE = -3.4028235E38f;
    public static final String SELECTOR_NAME = "zone";
    private ORFResource ressource;
    private Properties ressourceProperties = new Properties();
    private int oligoLength;

    public String getName() {
        return SELECTOR_NAME;
    }

    public String getDescription() {
        return "A Selector for ORF design";
    }

    public void init() throws TeolennException {
        try {
            this.ressource = ORFResource.getRessource(this.ressourceProperties);
        }
        catch (IOException e) {
            throw new TeolennException(e);
        }
        this.addMeasurement(new From5PrimeORFMeasurement(this.ressource, this.oligoLength));
        this.addMeasurement(new FromStartORFMeasurement());
        this.addMeasurement(new FromEndORFMeasurement());
        this.addMeasurement(new ORFMeasurement());
    }

    public void setInitParameter(String key, String value) {
        if (key == null || value == null) {
            return;
        }
        if ("_oligolength".equals(key)) {
            this.oligoLength = Integer.parseInt(value);
        }
        this.ressourceProperties.setProperty(key.toLowerCase(), value);
        super.setInitParameter(key, value);
    }

    public void doSelection() throws IOException {
        ORFResource orfRessource = this.ressource;
        int oligoLength = this.oligoLength;
        boolean first = true;
        int indexScaffold = -1;
        int indexStartPosition = -1;
        int indexORF = -1;
        int indexFromStart = -1;
        int indexFromEnd = -1;
        float bestScore = -3.4028235E38f;
        int valuesLength = -1;
        SequenceMeasurements sm = null;
        Object[] values = null;
        SequenceMeasurements smToWrite = new SequenceMeasurements();
        ORFResource.ORF lastORF = null;
        while ((sm = this.next()) != null) {
            float score;
            if (first) {
                indexScaffold = sm.getIndexMeasurment("Chromosome");
                indexStartPosition = sm.getIndexMeasurment("OligoStart");
                indexORF = sm.getIndexMeasurment("orf");
                indexFromStart = sm.getIndexMeasurment("fromstartorf");
                indexFromEnd = sm.getIndexMeasurment("fromendorf");
                values = sm.getArrayMeasurementValues();
                for (Measurement m : sm.getMeasurements()) {
                    smToWrite.addMesurement(m);
                }
                valuesLength = values.length;
                first = false;
            }
            String chromosome = (String)values[indexScaffold];
            int pos = (Integer)values[indexStartPosition];
            int id = sm.getId();
            ORFResource.ORF orf = orfRessource.getORF(chromosome, pos, oligoLength);
            if (!(lastORF == null || orf != null && lastORF.equals(orf))) {
                this.writeSelectedSequenceMeasurements(smToWrite);
                lastORF = null;
                bestScore = -3.4028235E38f;
            }
            if (orf == null) continue;
            if (lastORF == null) {
                lastORF = orf;
            }
            if (!((score = sm.getScore()) > bestScore)) continue;
            bestScore = score;
            smToWrite.setId(id);
            values[indexORF] = orf.toString();
            Object[] valuesToWrite = new Object[valuesLength];
            System.arraycopy(values, 0, valuesToWrite, 0, valuesLength);
            valuesToWrite[indexFromStart] = ZoneSelector.distanceFromStart(orf, pos);
            valuesToWrite[indexFromEnd] = ZoneSelector.distanceFromEnd(orf, pos, oligoLength);
            smToWrite.setArrayMeasurementValues(valuesToWrite);
        }
        if (lastORF != null) {
            this.writeSelectedSequenceMeasurements(smToWrite);
        }
        this.close();
    }

    private static final int distanceFromStart(ORFResource.ORF orf, int oligoPos) {
        return oligoPos - orf.start;
    }

    private static final int distanceFromEnd(ORFResource.ORF orf, int oligoPos, int oligoLength) {
        return orf.end - oligoPos - oligoLength;
    }
}

