/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.teolenn.sequence;

import fr.ens.transcriptome.teolenn.sequence.MeltingTemp;
import java.util.logging.Logger;

public class Sequence {
    private static final Logger logger = Logger.getLogger("Teolenn");
    private int id;
    private String sequence;
    private String name;
    final StringBuilder sb = new StringBuilder();

    public final String getSequence() {
        return this.sequence;
    }

    public final void setSequence(String sequence) {
        this.sequence = sequence;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public final float getTm() {
        return this.getTm(50.0f, 50.0f);
    }

    public final float getTm(float dnac, float saltc) {
        return MeltingTemp.tmstalucDNA(this.sequence, dnac, saltc);
    }

    public final float getGCPercent() {
        if (this.sequence == null) {
            return Float.NaN;
        }
        int len = this.sequence.length();
        int count = 0;
        for (int i = 0; i < len; ++i) {
            if (this.sequence.charAt(i) != 'G' && this.sequence.charAt(i) != 'C') continue;
            ++count;
        }
        return (float)count / (float)len;
    }

    public int getStartPositionOligo() {
        if (this.name == null) {
            return -1;
        }
        int startPos = this.name.indexOf(":subseq(");
        int endPos = this.name.indexOf(",", startPos);
        return Integer.parseInt(this.name.substring(startPos + 8, endPos));
    }

    public int getLengthOligo() {
        if (this.sequence != null) {
            return this.sequence.length();
        }
        if (this.name == null) {
            return -1;
        }
        int startPos = this.name.indexOf(":subseq(");
        int startPos2 = this.name.indexOf(",", startPos);
        int endPos = this.name.indexOf(")", startPos2);
        return Integer.parseInt(this.name.substring(startPos2 + 1, endPos));
    }

    public void reverseComplementSequence() {
        if (this.sequence == null) {
            return;
        }
        int len = this.sequence.length();
        block10: for (int i = 0; i < len; ++i) {
            switch (this.sequence.charAt(i)) {
                case 'A': {
                    this.sb.append('T');
                    continue block10;
                }
                case 'T': {
                    this.sb.append('A');
                    continue block10;
                }
                case 'G': {
                    this.sb.append('C');
                    continue block10;
                }
                case 'C': {
                    this.sb.append('G');
                    continue block10;
                }
                case 'a': {
                    this.sb.append('t');
                    continue block10;
                }
                case 't': {
                    this.sb.append('a');
                    continue block10;
                }
                case 'g': {
                    this.sb.append('c');
                    continue block10;
                }
                case 'c': {
                    this.sb.append('c');
                    continue block10;
                }
                default: {
                    this.sb.append(this.sequence.charAt(i));
                    logger.warning("Unknown nucleotide: " + this.sequence.charAt(i) + " in sequence " + this.name);
                }
            }
        }
        this.sequence = this.sb.reverse().toString();
    }

    public String toString() {
        return "(" + this.name + "," + this.sequence + ")";
    }

    public Sequence() {
    }

    public Sequence(String name, String sequence) {
        this.setName(name);
        this.setSequence(sequence);
    }
}

