/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.teolenn.sequence;

import fr.ens.transcriptome.teolenn.sequence.Sequence;
import fr.ens.transcriptome.teolenn.util.FileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;

public class SequenceIterator
extends Sequence {
    private static Logger logger = Logger.getLogger("Teolenn");
    private File inputFile;
    private final StringBuilder sequence = new StringBuilder();
    private final BufferedReader br;
    private String nextSequenceName;

    public boolean hasNext() {
        return this.nextSequenceName != null;
    }

    public String next() {
        try {
            String line;
            while ((line = this.br.readLine()) != null) {
                if (line.startsWith(">")) {
                    this.setName(this.nextSequenceName);
                    this.nextSequenceName = SequenceIterator.extractSequenceName(line);
                    String result = this.sequence.toString();
                    this.sequence.setLength(0);
                    this.setSequence(result);
                    return result;
                }
                this.sequence.append(line.trim());
            }
            this.br.close();
            this.setName(this.nextSequenceName);
            this.nextSequenceName = null;
        }
        catch (IOException e) {
            System.err.println("Error while reading fasta file (" + this.inputFile + "): " + e.getMessage());
            logger.severe("Error while reading fasta file (" + this.inputFile + "): " + e.getMessage());
            return null;
        }
        String result = this.sequence.toString();
        this.setSequence(result);
        return result;
    }

    private static final String extractSequenceName(String line) {
        if (line == null) {
            return null;
        }
        return line.trim().substring(1);
    }

    public SequenceIterator(File inputFile) throws IOException {
        this.inputFile = inputFile;
        this.br = FileUtils.createBufferedReader(inputFile);
        try {
            this.nextSequenceName = SequenceIterator.extractSequenceName(this.br.readLine());
        }
        catch (IOException e) {
            System.err.println("Error while reading first line of the fasta file (" + inputFile + "): " + e.getMessage());
            throw new IOException("Error while reading first line of the fasta file (" + inputFile + "): " + e.getMessage());
        }
    }
}

