/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.teolenn.sequence;

import fr.ens.transcriptome.teolenn.measurement.Measurement;
import fr.ens.transcriptome.teolenn.sequence.Sequence;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceMeasurements {
    private int id;
    private Sequence sequence;
    private final List<Measurement> measurements = new ArrayList<Measurement>();
    private final Map<String, Integer> measurementsIndex = new HashMap<String, Integer>();
    private Object[] measurementValues;
    private Measurement[] arrayMeasurements;
    private Map<Measurement, Float> weights = new HashMap<Measurement, Float>();

    public int getId() {
        return this.id;
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setSequence(Sequence sequence) {
        this.sequence = sequence;
    }

    public int size() {
        return this.measurements.size();
    }

    public void addMesurement(Measurement m) {
        this.addMesurement(m, 1.0f);
    }

    public boolean isMeasurement(String measurementName) {
        if (measurementName == null) {
            return false;
        }
        return this.measurementsIndex.containsKey(measurementName.trim().toLowerCase());
    }

    public void addMesurement(Measurement m, float weight) {
        if (m == null) {
            return;
        }
        this.measurements.add(m);
        this.measurementsIndex.put(m.getName().toLowerCase(), this.measurementsIndex.size());
        this.arrayMeasurements = null;
        this.setWeight(m, weight);
    }

    public void calcMesurements() {
        if (this.arrayMeasurements == null) {
            this.arrayMeasurements = this.measurements.toArray(new Measurement[0]);
            this.measurementValues = new Object[this.arrayMeasurements.length];
        }
        for (int i = 0; i < this.arrayMeasurements.length; ++i) {
            this.measurementValues[i] = this.arrayMeasurements[i].calcMesurement(this.sequence);
        }
    }

    public void addMesurementsToStats() {
        if (this.arrayMeasurements == null) {
            this.arrayMeasurements = this.measurements.toArray(new Measurement[0]);
        }
        for (int i = 0; i < this.arrayMeasurements.length; ++i) {
            this.arrayMeasurements[i].addLastMeasurementToStats();
        }
    }

    public Object[] getArrayMeasurementValues() {
        return this.measurementValues;
    }

    public String[] getArrayMesurementNames() {
        String[] result = new String[this.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.measurements.get(i).getName();
        }
        return result;
    }

    public int getIndexMeasurment(String name) {
        if (name == null) {
            return -1;
        }
        Integer result = this.measurementsIndex.get(name.toLowerCase());
        if (result == null) {
            return -1;
        }
        return result;
    }

    public Measurement getMeasurement(String name) {
        int index = this.getIndexMeasurment(name);
        return index < 0 ? null : this.measurements.get(index);
    }

    public float getWeight(Measurement m) {
        Float result = this.weights.get(m);
        if (result == null) {
            return Float.NaN;
        }
        return result.floatValue();
    }

    public void setWeight(Measurement m, float weight) {
        this.weights.put(m, Float.valueOf(weight));
    }

    public void setArrayMeasurementValues(Object[] values) {
        this.measurementValues = values;
    }

    public float getScore() {
        float result = 0.0f;
        int count = 0;
        Object[] values = this.getArrayMeasurementValues();
        for (Measurement m : this.measurements) {
            Object value = values[count++];
            float score = m.getScore(value);
            float scoreWithWeigth = score * this.weights.get(m).floatValue();
            result += scoreWithWeigth;
        }
        return result;
    }

    public List<Measurement> getMeasurements() {
        return Collections.unmodifiableList(this.measurements);
    }

    public boolean isSumOfWeightEquals1() {
        float sum = 0.0f;
        for (Measurement m : this.measurements) {
            sum += this.weights.get(m).floatValue();
        }
        return sum == 1.0f;
    }
}

