/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.teolenn.sequence;

import fr.ens.transcriptome.teolenn.measurement.Measurement;
import fr.ens.transcriptome.teolenn.sequence.SequenceMeasurements;
import fr.ens.transcriptome.teolenn.util.FileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class SequenceMeasurementsStatReader {
    private BufferedReader br;
    private SequenceMeasurements sm;
    private static final Pattern tabPattern = Pattern.compile("\t");

    public SequenceMeasurements read() throws IOException {
        String line;
        SequenceMeasurements sm = this.sm;
        Measurement[] arrayMs = null;
        boolean first = true;
        while ((line = this.br.readLine()) != null) {
            int i;
            String[] fields = tabPattern.split(line);
            if (first) {
                ArrayList<Measurement> listMs = new ArrayList<Measurement>();
                for (i = 1; i < fields.length; ++i) {
                    listMs.add(sm.getMeasurement(fields[i]));
                }
                arrayMs = listMs.toArray(new Measurement[0]);
                first = false;
                continue;
            }
            String property = fields[0];
            for (i = 1; i < fields.length; ++i) {
                String value = fields[i].trim();
                Measurement m = arrayMs[i - 1];
                if (m == null || "".equals(value)) continue;
                m.setProperty(property, value);
            }
        }
        this.br.close();
        return sm;
    }

    public SequenceMeasurementsStatReader(File file, SequenceMeasurements sm) throws IOException {
        if (file == null) {
            throw new NullPointerException("File is null");
        }
        if (sm == null) {
            throw new NullPointerException("SequenceMeasurements is null");
        }
        this.br = FileUtils.createBufferedReader(file);
        this.sm = sm;
    }
}

