/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.teolenn.sequence;

import fr.ens.transcriptome.teolenn.measurement.Measurement;
import fr.ens.transcriptome.teolenn.sequence.SequenceMeasurements;
import fr.ens.transcriptome.teolenn.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;

public class SequenceMeasurementsStatWriter {
    private Writer writer;

    public void write(SequenceMeasurements sm) throws IOException {
        if (sm == null) {
            throw new NullPointerException("SequenceMesurement is null");
        }
        String[] mNames = sm.getArrayMesurementNames();
        ArrayList<Measurement> listM = new ArrayList<Measurement>();
        for (int i = 0; i < mNames.length; ++i) {
            listM.add(sm.getMeasurement(mNames[i]));
        }
        LinkedHashSet<String> pNames = new LinkedHashSet<String>();
        HashMap<Measurement, Properties> properties = new HashMap<Measurement, Properties>();
        for (Measurement measurement : sm.getMeasurements()) {
            properties.put(measurement, measurement.computeStatistics());
        }
        for (Map.Entry entry : properties.entrySet()) {
            Properties p2 = (Properties)entry.getValue();
            if (p2 == null) continue;
            for (Object name : p2.keySet()) {
                pNames.add((String)name);
            }
        }
        for (int i = 0; i < mNames.length; ++i) {
            this.writer.append("\t");
            this.writer.append(mNames[i]);
        }
        this.writer.append("\n");
        ArrayList pNamesSorted = new ArrayList(pNames);
        Collections.sort(pNamesSorted);
        for (String pName : pNamesSorted) {
            this.writer.append(pName);
            for (Measurement m : listM) {
                String v;
                this.writer.append("\t");
                Properties ps = (Properties)properties.get(m);
                if (ps == null || (v = ps.getProperty(pName)) == null) continue;
                this.writer.append(v);
            }
            this.writer.append("\n");
        }
        this.writer.close();
    }

    public SequenceMeasurementsStatWriter(File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("File is null");
        }
        this.writer = FileUtils.createBufferedWriter(file);
    }
}

