/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.teolenn.sequence;

import fr.ens.transcriptome.teolenn.sequence.Sequence;
import fr.ens.transcriptome.teolenn.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.Writer;

public class SequenceWriter {
    private static final int FASTA_MAX_LEN = 70;
    private Writer writer;
    private final StringBuffer sb = new StringBuffer();

    public void write(Sequence sequence) throws IOException {
        this.sb.append(">");
        this.sb.append(sequence.getName());
        this.sb.append("\n");
        String s = sequence.getSequence();
        int pos = 0;
        int len = s.length();
        while (pos < len) {
            int newPos = pos + 70;
            this.sb.append(s.substring(pos, newPos > len ? len : newPos));
            this.sb.append("\n");
            pos = newPos;
        }
        this.writer.write(this.sb.toString());
        this.sb.setLength(0);
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public SequenceWriter(File outputFile) throws IOException {
        this.writer = FileUtils.createBufferedWriter(outputFile);
    }
}

