/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.teolenn.sequence.filter;

import fr.ens.transcriptome.teolenn.TeolennException;
import fr.ens.transcriptome.teolenn.resource.ORFResource;
import fr.ens.transcriptome.teolenn.sequence.Sequence;
import fr.ens.transcriptome.teolenn.sequence.filter.SequenceFilter;
import java.io.IOException;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ORFsFilter
implements SequenceFilter {
    public static final String SEQUENCE_FILTER_NAME = "orfs";
    private ORFResource ressource;
    private Properties ressourceProperties = new Properties();
    private static final Pattern seqNamePattern = Pattern.compile("^(.*):subseq\\((\\d+),(\\d+)\\)$");

    public String getName() {
        return SEQUENCE_FILTER_NAME;
    }

    public String getDescription() {
        return "Filter ORFs";
    }

    public boolean accept(Sequence sequence) {
        int len;
        int start;
        String sequenceName = sequence.getName();
        if (sequenceName == null) {
            return false;
        }
        Matcher m = seqNamePattern.matcher(sequenceName);
        if (!m.matches()) {
            throw new RuntimeException("Unable to parse sequence name: " + sequenceName);
        }
        String chr = m.group(1);
        return this.ressource.getORF(chr, start = Integer.parseInt(m.group(2)), len = Integer.parseInt(m.group(3))) != null;
    }

    public void setInitParameter(String key, String value) {
        if (key == null || value == null) {
            return;
        }
        this.ressourceProperties.setProperty(key.toLowerCase(), value);
    }

    public void init() throws TeolennException {
        try {
            this.ressource = ORFResource.getRessource(this.ressourceProperties);
        }
        catch (IOException e) {
            throw new TeolennException(e);
        }
    }
}

