/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.teolenn.sequence.filter;

import fr.ens.transcriptome.teolenn.Settings;
import fr.ens.transcriptome.teolenn.TeolennException;
import fr.ens.transcriptome.teolenn.sequence.Sequence;
import fr.ens.transcriptome.teolenn.sequence.filter.SequenceFilter;
import fr.ens.transcriptome.teolenn.util.BinariesInstaller;
import fr.ens.transcriptome.teolenn.util.FileUtils;
import fr.ens.transcriptome.teolenn.util.ProcessUtils;
import fr.ens.transcriptome.teolenn.util.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RedundancyFilter
implements SequenceFilter {
    private static Logger logger = Logger.getLogger("Teolenn");
    public static final String SEQUENCE_FILTER_NAME = "redundancy";
    private static final String SOAP_ARGS = " -s 12 -v 5 -r 1 -w 1000 -p ";
    private File referenceFile;
    private File[] oligosFiles;
    private File oligosDir;
    private File tempDir;
    private BufferedReader br;
    private String currentChr;
    private int startOffset;
    private String extensionFilter;
    private final Map<Integer, Map<Integer, Integer>> currentChrResult = new HashMap<Integer, Map<Integer, Integer>>();
    private static final Pattern seqNamePattern = Pattern.compile("^(.*):subseq\\((\\d+),(\\d+)\\)$");

    public String getName() {
        return SEQUENCE_FILTER_NAME;
    }

    public String getDescription() {
        return "Filter the redundancy of oligos using SOAP";
    }

    public boolean accept(Sequence sequence) {
        String sequenceName = sequence.getName();
        if (sequenceName == null) {
            return false;
        }
        Matcher m = seqNamePattern.matcher(sequenceName);
        if (!m.matches()) {
            throw new RuntimeException("Unable to parse sequence name: " + sequenceName);
        }
        String chr = m.group(1);
        int startPos = Integer.parseInt(m.group(2));
        int len = Integer.parseInt(m.group(3));
        try {
            Map<Integer, Integer> map;
            if (!chr.equals(this.currentChr)) {
                this.parseResultFile(chr);
                this.currentChr = chr;
            }
            if ((map = this.currentChrResult.get(len)) == null) {
                return false;
            }
            Integer result = map.get(startPos);
            return result != null && result == len;
        }
        catch (IOException e) {
            throw new RuntimeException("Error while reading Soap results: " + e.getMessage());
        }
    }

    private final void parseResultFile(String chrSequence) throws IOException {
        if (this.br != null) {
            this.br.close();
        }
        this.br = FileUtils.createBufferedReader(new File(this.tempDir, chrSequence.replace(' ', '_') + ".sop"));
        this.currentChrResult.clear();
        int startOffset = this.startOffset;
        String l = null;
        while ((l = this.br.readLine()) != null) {
            int matchType;
            String line = l;
            int subSeqPos = RedundancyFilter.indexOf(line, ':', 0);
            int commaPos = RedundancyFilter.indexOf(line, ',', subSeqPos);
            int bracketPos = RedundancyFilter.indexOf(line, ')', commaPos);
            int posTabSeq = RedundancyFilter.indexOf(line, '\t', bracketPos);
            int posTabUnknown1 = RedundancyFilter.indexOf(line, '\t', posTabSeq);
            int posTabNbMatches = RedundancyFilter.indexOf(line, '\t', posTabUnknown1);
            int posTabUnknown2 = RedundancyFilter.indexOf(line, '\t', posTabNbMatches);
            int posTabLen = RedundancyFilter.indexOf(line, '\t', posTabUnknown2);
            int posTabStrand = RedundancyFilter.indexOf(line, '\t', posTabLen);
            int posTabChr = RedundancyFilter.indexOf(line, '\t', posTabStrand);
            int posTabMatchStart = RedundancyFilter.indexOf(line, '\t', posTabChr);
            int posTabMatchType = RedundancyFilter.indexOf(line, '\t', posTabMatchStart);
            int posTabNucleotideModifs = RedundancyFilter.indexOf(line, '\t', posTabMatchType);
            if (posTabMatchType == -1) continue;
            String chr = line.substring(0, subSeqPos);
            int oligoPos = Integer.parseInt(line.substring(subSeqPos + 8, commaPos));
            int oligoLen = Integer.parseInt(line.substring(commaPos + 1, bracketPos));
            int nbMatches = Integer.parseInt(line.substring(posTabNbMatches + 1, posTabUnknown2));
            int matchLen = Integer.parseInt(line.substring(posTabLen + 1, posTabStrand));
            char matchStrand = line.charAt(posTabStrand + 1);
            String matchChr = line.substring(posTabChr + 1, posTabMatchStart);
            int matchStart = Integer.parseInt(line.substring(posTabMatchStart + 1, posTabMatchType)) + startOffset;
            int n = matchType = posTabNucleotideModifs == -1 ? Integer.parseInt(line.substring(posTabMatchType + 1)) : Integer.parseInt(line.substring(posTabMatchType + 1, posTabNucleotideModifs));
            if (nbMatches != 1 || matchType != 0 || matchStrand != '+' || !chr.equals(matchChr) || oligoPos != matchStart) continue;
            if (!this.currentChrResult.containsKey(oligoLen)) {
                this.currentChrResult.put(oligoLen, new HashMap());
            }
            this.currentChrResult.get(oligoLen).put(oligoPos, matchLen);
        }
    }

    private static final int indexOf(String ch, char character, int startPos) {
        if (startPos == -1) {
            return -1;
        }
        int p = startPos;
        int len = ch.length();
        while (++p < len) {
            if (ch.codePointAt(p) != character) continue;
            return p;
        }
        return -1;
    }

    private void createParameterFile(File parameterFile, File[] oligosFiles) throws IOException {
        FileWriter fw = new FileWriter(parameterFile);
        for (int i = 0; i < oligosFiles.length; ++i) {
            fw.append("-a ");
            String oligoFile = oligosFiles[i].getAbsolutePath();
            fw.append(oligoFile);
            fw.append(" -o ");
            fw.append(this.tempDir.getAbsolutePath());
            fw.append(File.separatorChar);
            fw.append(StringUtils.basename(oligosFiles[i].getName()) + ".sop");
            fw.append(SOAP_ARGS + Settings.getMaxThreads());
            fw.append("\n");
        }
        fw.close();
    }

    public void setInitParameter(String key, String value) {
        if ("_start1".equals(key)) {
            boolean start1 = Boolean.parseBoolean(value);
            this.startOffset = start1 ? 0 : -1;
        } else if ("_genomefile".equals(key)) {
            this.referenceFile = new File(value);
        } else if ("_tempdir".equals(key)) {
            this.tempDir = new File(value);
        } else if ("_oligodir".equals(key)) {
            this.oligosDir = new File(value);
        } else if ("_extensionfilter".equals(key)) {
            this.extensionFilter = value;
        }
    }

    public void init() throws TeolennException {
        if (this.extensionFilter == null || "".equals(this.extensionFilter)) {
            throw new TeolennException("No extension filter set.");
        }
        this.oligosFiles = this.oligosDir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(RedundancyFilter.this.extensionFilter);
            }
        });
        try {
            if (Settings.getSoapPath() == null) {
                Settings.setSoapPath(BinariesInstaller.install("soap"));
            }
            File paramFile = File.createTempFile("soap-", ".param");
            this.createParameterFile(paramFile, this.oligosFiles);
            String cmd = Settings.getSoapPath() + " -d " + this.referenceFile.getAbsolutePath() + " " + paramFile.getAbsolutePath();
            ProcessUtils.exec(cmd, Settings.isStandardOutputForExecutable());
            if (!paramFile.delete()) {
                logger.warning("Can't remove redundancy parameter file: " + paramFile.getAbsolutePath());
            }
        }
        catch (IOException e) {
            throw new TeolennException("Error while initialize redundancy sequence filter: " + e.getMessage());
        }
    }
}

