/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.teolenn.sequence.filter;

import fr.ens.transcriptome.teolenn.sequence.filter.ORFsFilter;
import fr.ens.transcriptome.teolenn.sequence.filter.RedundancyFilter;
import fr.ens.transcriptome.teolenn.sequence.filter.RemoveXSequenceFilter;
import fr.ens.transcriptome.teolenn.sequence.filter.SequenceFilter;
import fr.ens.transcriptome.teolenn.sequence.filter.SequenceNotATGCFilter;
import fr.ens.transcriptome.teolenn.sequence.filter.SequenceXNFilter;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class SequenceFilterRegistery {
    private static Logger logger = Logger.getLogger("Teolenn");
    private static Map<String, Class> registery = new HashMap<String, Class>();

    public static void addSequenceFilterType(String name, Class clazz) {
        if (name == null || clazz == null) {
            return;
        }
        if (SequenceFilterRegistery.testClassType(clazz)) {
            String lowerName = name.toLowerCase();
            if (registery.containsKey(lowerName)) {
                logger.warning("Sequence filter " + name + " already exits, override previous sequence filter.");
            }
            registery.put(lowerName, clazz);
            logger.finest("Add " + name + " to Sequence filters registery");
        } else {
            logger.warning("Addon " + name + " is not a sequence filter class");
        }
    }

    public static void addSequenceFilterType(String name, String className) {
        if (name == null || "".equals(name) || className == null) {
            return;
        }
        try {
            Class<?> clazz = Class.forName(className);
            SequenceFilterRegistery.addSequenceFilterType(name.toLowerCase(), clazz);
            logger.info("Add external measurement: " + name);
        }
        catch (ClassNotFoundException e) {
            logger.severe("Cannot find " + className + " for " + name + " measurement addon");
            throw new RuntimeException("Cannot find " + className + " for " + name + " measurement addon");
        }
    }

    private static boolean testClassType(Class clazz) {
        if (clazz == null) {
            return false;
        }
        try {
            return clazz.newInstance() instanceof SequenceFilter;
        }
        catch (InstantiationException e) {
            logger.severe("Can't create instance of " + clazz.getName() + ". Maybe your class doesn't have a void constructor.");
        }
        catch (IllegalAccessException e) {
            logger.severe("Can't access to " + clazz.getName());
        }
        return false;
    }

    public static SequenceFilter getSequenceFilter(String name) {
        if (name == null) {
            return null;
        }
        Class clazz = registery.get(name.toLowerCase());
        if (clazz == null) {
            return null;
        }
        try {
            return (SequenceFilter)clazz.newInstance();
        }
        catch (InstantiationException e) {
            System.err.println("Unable to instantiate " + name + " filter. Maybe this filter doesn't have a void constructor.");
            logger.severe("Unable to instantiate " + name + " filter. Maybe this filter doesn't have a void constructor.");
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    static {
        SequenceFilterRegistery.addSequenceFilterType("redundancy", RedundancyFilter.class);
        SequenceFilterRegistery.addSequenceFilterType("removex", RemoveXSequenceFilter.class);
        SequenceFilterRegistery.addSequenceFilterType("sequencexn", SequenceXNFilter.class);
        SequenceFilterRegistery.addSequenceFilterType("notatgc", SequenceNotATGCFilter.class);
        SequenceFilterRegistery.addSequenceFilterType("orfs", ORFsFilter.class);
    }
}

