/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.teolenn.util;

import fr.ens.transcriptome.teolenn.Globals;
import fr.ens.transcriptome.teolenn.util.FileUtils;
import fr.ens.transcriptome.teolenn.util.SystemUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;

public class BinariesInstaller {
    private static Logger logger = Logger.getLogger("Teolenn");
    private static final int BUFFER_SIZE = 32768;

    private static void install(String inputPath, String file, String outputPath) throws FileNotFoundException, IOException {
        if (new File(outputPath, file).isFile()) {
            logger.fine(file + " is allready installed.");
            return;
        }
        String resourcePath = inputPath.toLowerCase() + "/" + file;
        InputStream is = BinariesInstaller.class.getResourceAsStream(resourcePath);
        if (is == null) {
            throw new FileNotFoundException("Unable to find the correct resource (" + resourcePath + ")");
        }
        File outputDir = new File(outputPath);
        if (!outputDir.isDirectory() && !outputDir.mkdirs()) {
            throw new IOException("Can't create directory for binaries installation: " + outputDir.getAbsolutePath());
        }
        File outputFile = new File(outputDir, file);
        FileOutputStream fos = new FileOutputStream(outputFile);
        byte[] buf = new byte[32768];
        int i = 0;
        while ((i = is.read(buf)) != -1) {
            ((OutputStream)fos).write(buf, 0, i);
        }
        is.close();
        ((OutputStream)fos).close();
        FileUtils.setExecutable(outputFile, false);
        FileUtils.setReadable(outputFile, false);
    }

    public static String install(String file) throws IOException {
        String os = System.getProperty("os.name");
        String arch = System.getProperty("os.arch");
        logger.fine("Try to install \"" + file + "\" for " + os + " (" + arch + ")");
        boolean linux = SystemUtils.isLinux();
        boolean macos = SystemUtils.isMacOsX();
        if (!linux && !macos) {
            throw new FileNotFoundException("There is no executable for your plateform (" + os + ") included in " + "Teolenn");
        }
        if (linux && !"i386".equals(arch) && !"amd64".equals(arch)) {
            throw new FileNotFoundException("There is no executable for your architecture (" + arch + ") included in " + "Teolenn");
        }
        String inputPath = "/" + os.replace(" ", "") + "/" + arch;
        String outputPath = "/tmp/" + Globals.APP_NAME_LOWER_CASE + "/" + Globals.APP_VERSION;
        if (new File(outputPath, file).isFile()) {
            logger.info(file + " is allready installed.");
            return outputPath + "/" + file;
        }
        BinariesInstaller.install(inputPath, file, outputPath);
        logger.fine("Successful installation of " + file + " in " + outputPath);
        return outputPath + "/" + file;
    }

    public static void main(String[] args) throws IOException {
        BinariesInstaller.install("gt");
        BinariesInstaller.install("soap");
    }
}

