/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.teolenn.util;

import fr.ens.transcriptome.teolenn.util.ProcessUtils;
import fr.ens.transcriptome.teolenn.util.UnSynchronizedBufferedWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.List;
import java.util.zip.GZIPOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileUtils {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final String CHARSET = "ISO-8859-1";

    public static final BufferedReader createBufferedReader(File file) throws FileNotFoundException {
        if (file == null) {
            return null;
        }
        FileInputStream inFile = new FileInputStream(file);
        FileChannel inChannel = inFile.getChannel();
        return new BufferedReader(new InputStreamReader(Channels.newInputStream(inChannel)));
    }

    public static final UnSynchronizedBufferedWriter createBufferedWriter(File file) throws FileNotFoundException {
        if (file == null) {
            return null;
        }
        if (file.isFile()) {
            file.delete();
        }
        FileOutputStream outFile = new FileOutputStream(file);
        FileChannel outChannel = outFile.getChannel();
        return new UnSynchronizedBufferedWriter(new OutputStreamWriter(Channels.newOutputStream(outChannel), Charset.forName(CHARSET)));
    }

    public static final UnSynchronizedBufferedWriter createBufferedGZipWriter(File file) throws IOException {
        if (file == null) {
            return null;
        }
        if (file.exists()) {
            file.delete();
        }
        FileOutputStream outFile = new FileOutputStream(file);
        FileChannel outChannel = outFile.getChannel();
        GZIPOutputStream gzos = new GZIPOutputStream(Channels.newOutputStream(outChannel));
        return new UnSynchronizedBufferedWriter(new OutputStreamWriter((OutputStream)gzos, Charset.forName(CHARSET)));
    }

    public static final ObjectOutputStream createObjectOutputWriter(File file) throws IOException {
        if (file == null) {
            return null;
        }
        if (file.exists()) {
            file.delete();
        }
        FileOutputStream outFile = new FileOutputStream(file);
        FileChannel outChannel = outFile.getChannel();
        return new ObjectOutputStream(Channels.newOutputStream(outChannel));
    }

    public static final ObjectInputStream createObjectInputReader(File file) throws IOException {
        if (file == null) {
            return null;
        }
        FileInputStream inFile = new FileInputStream(file);
        FileChannel inChannel = inFile.getChannel();
        return new ObjectInputStream(Channels.newInputStream(inChannel));
    }

    public static int copy(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        int count = 0;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += n;
        }
        return count;
    }

    public static File[] listFilesByExtension(File directory, final String extension) {
        if (directory == null || extension == null) {
            return null;
        }
        return directory.listFiles(new FilenameFilter(){

            public boolean accept(File arg0, String arg1) {
                return arg1.endsWith(extension);
            }
        });
    }

    public static boolean removeFiles(File[] filesToRemove, boolean recursive) {
        if (filesToRemove == null) {
            return false;
        }
        for (int i = 0; i < filesToRemove.length; ++i) {
            File f = filesToRemove[i];
            if (f.isDirectory()) {
                if (!recursive) continue;
                if (!FileUtils.removeFiles(FileUtils.listFilesByExtension(f, ""), true)) {
                    return false;
                }
                if (f.delete()) continue;
                return false;
            }
            if (f.delete()) continue;
            return false;
        }
        return true;
    }

    public static String getPrefix(List<File> files) {
        if (files == null) {
            return null;
        }
        File[] param = new File[files.size()];
        files.toArray(param);
        return FileUtils.getPrefix(param);
    }

    public static String getPrefix(File[] files) {
        if (files == null) {
            return null;
        }
        String prefix = null;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < files.length; ++i) {
            String filename = files[i].getName();
            if (prefix == null) {
                prefix = filename;
                continue;
            }
            if (filename.startsWith(prefix)) continue;
            int max = Math.min(prefix.length(), filename.length());
            for (int j = 0; j < max; ++j) {
                if (prefix.charAt(j) != filename.charAt(j)) continue;
                sb.append(prefix.charAt(j));
            }
            prefix = sb.toString();
            sb.setLength(0);
        }
        return prefix;
    }

    public static boolean setExecutable(File file, boolean executable, boolean ownerOnly) throws IOException {
        if (file == null) {
            return false;
        }
        if (!file.exists() || !file.isFile()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        String cmd = "chmod " + (ownerOnly ? "u+x " : "ugo+x ") + file.getAbsolutePath();
        ProcessUtils.exec(cmd, false);
        return true;
    }

    public static boolean setExecutable(File file, boolean executable) throws IOException {
        return FileUtils.setExecutable(file, executable, false);
    }

    public static boolean setReadable(File file, boolean readable, boolean ownerOnly) throws IOException {
        if (file == null) {
            return false;
        }
        if (!file.exists() || !file.isFile()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        String cmd = "chmod " + (ownerOnly ? "u+r " : "ugo+r ") + file.getAbsolutePath();
        ProcessUtils.exec(cmd, true);
        return true;
    }

    public static boolean setReadable(File file, boolean readable) throws IOException {
        return FileUtils.setReadable(file, readable, true);
    }

    public static boolean setWritable(File file, boolean writable, boolean ownerOnly) throws IOException {
        if (file == null) {
            return false;
        }
        if (!file.exists() || !file.isFile()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        String cmd = "chmod " + (ownerOnly ? "u+w " : "ugo+w ") + file.getAbsolutePath();
        ProcessUtils.exec(cmd, true);
        return true;
    }

    public static boolean setWritable(File file, boolean writable) throws IOException {
        return FileUtils.setWritable(file, writable, true);
    }
}

