/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.teolenn.util;

public class Histogram {
    private double min;
    private double max;
    private int bins;
    private double step;
    private int count;
    private int[] array;

    public Histogram(double min, double max, int bins) {
        if (bins <= 0) {
            throw new RuntimeException("Invalid parameter: bins=" + bins);
        }
        this.min = Math.min(min, max);
        this.max = Math.max(min, max);
        this.step = (max - min) / (double)bins;
        this.array = new int[bins + 1];
    }

    public void addValue(double value) {
        if (value < this.min || value >= this.max) {
            int n = this.bins;
            this.array[n] = this.array[n] + 1;
        } else {
            int n = (int)((value - this.min) / this.step);
            this.array[n] = this.array[n] + 1;
        }
        ++this.count;
    }

    public double[] getHistogram() {
        double[] result = new double[this.array.length];
        for (int i = 0; i < this.array.length; ++i) {
            result[i] = (double)this.array[i] / (double)this.count;
        }
        return result;
    }

    public void clear() {
        this.count = 0;
        for (int i = 0; i < this.array.length; ++i) {
            this.array[i] = 0;
        }
    }
}

