/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.teolenn.util;

import java.util.Collection;
import org.apache.commons.math.stat.descriptive.rank.Median;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MathUtils {
    private static final int BASE_10 = 10;
    private static final int BASE_2 = 2;

    public static double sdFast(double[] data) {
        if (data == null) {
            return Double.NaN;
        }
        double mean = 0.0;
        int n = data.length;
        if (n < 2) {
            return Double.NaN;
        }
        for (int i = 0; i < n; ++i) {
            mean += data[i];
        }
        mean /= (double)n;
        double sum = 0.0;
        for (int i = 0; i < n; ++i) {
            double v = data[i] - mean;
            sum += v * v;
        }
        return Math.sqrt(sum / (double)(n - 1));
    }

    public static double log10(double d) {
        return Math.log(d) / Math.log(10.0);
    }

    public static double log2(double d) {
        return Math.log(d) / Math.log(2.0);
    }

    public static double[] removeNaN(double[] data) {
        if (data == null) {
            return null;
        }
        int count = 0;
        for (int i = 0; i < data.length; ++i) {
            if (!Double.isNaN(data[i])) continue;
            ++count;
        }
        if (count == 0) {
            return data;
        }
        double[] result = new double[count];
        count = 0;
        for (int i = 0; i < result.length; ++i) {
            if (Double.isNaN(data[i])) continue;
            result[count++] = data[i];
        }
        return result;
    }

    public static double median(double[] data) {
        return MathUtils.median(data, true);
    }

    public static double median(double[] data, boolean noNaN) {
        if (data == null) {
            return Double.NaN;
        }
        Median median = new Median();
        return median.evaluate(noNaN ? MathUtils.removeNaN(data) : data);
    }

    public static double mean(double[] data, boolean noNaN) {
        return MathUtils.mean(noNaN ? MathUtils.removeNaN(data) : data);
    }

    public static double mean(double[] data) {
        if (data == null) {
            return Double.NaN;
        }
        int count = 0;
        float sum = 0.0f;
        for (int i = 0; i < data.length; ++i) {
            ++count;
            sum = (float)((double)sum + data[i]);
        }
        return sum / (float)count;
    }

    public static double[] toArray(Collection<Float> col) {
        if (col == null) {
            return null;
        }
        double[] result = new double[col.size()];
        int i = 0;
        for (Float val : col) {
            result[i++] = val.floatValue();
        }
        return result;
    }

    public static double[] histogram(double[] data, double min, double max, int bins) {
        if (data == null || bins <= 0) {
            return null;
        }
        double step = (max - min) / (double)bins;
        int[] array = new int[bins + 1];
        int count = 0;
        for (int i = 0; i < data.length; ++i) {
            double v = data[i];
            if (v < min || v >= max) {
                int n = bins;
                array[n] = array[n] + 1;
            } else {
                int n = (int)((v - min) / step);
                array[n] = array[n] + 1;
            }
            ++count;
        }
        double[] result = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = (double)array[i] / (double)count;
        }
        return result;
    }

    private MathUtils() {
    }
}

