/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.teolenn.util;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public abstract class PoolLoopHandler
implements Runnable {
    protected static ThreadPoolExecutor threadpool;
    protected static int maxThreads;
    protected int startLoop;
    protected int endLoop;
    protected int curLoop;
    protected int numThreads;

    static synchronized void getThreadPool(int threads) {
        if (threadpool == null) {
            threadpool = new ThreadPoolExecutor(1, 1, 50000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new PoolHandlerFactory());
        }
        if (threads > maxThreads) {
            maxThreads = threads;
            threadpool.setMaximumPoolSize(maxThreads);
            threadpool.setCorePoolSize(maxThreads);
        }
    }

    public PoolLoopHandler(int start, int end, int threads) {
        this.numThreads = threads;
        PoolLoopHandler.getThreadPool(this.numThreads);
        this.setRange(start, end);
    }

    public synchronized void setRange(int start, int end) {
        this.startLoop = start;
        this.endLoop = end;
        this.reset();
    }

    public synchronized void reset() {
        this.curLoop = this.startLoop;
    }

    protected synchronized LoopRange loopGetRange() {
        if (this.curLoop >= this.endLoop) {
            return null;
        }
        LoopRange ret = new LoopRange();
        ret.start = this.curLoop;
        this.curLoop += (this.endLoop - this.startLoop) / this.numThreads + 1;
        ret.end = this.curLoop < this.endLoop ? this.curLoop : this.endLoop;
        return ret;
    }

    public abstract void loopDoRange(int var1, int var2);

    public void loopProcess() {
        int i;
        this.reset();
        FutureTask[] t = new FutureTask[this.numThreads];
        for (i = 0; i < this.numThreads; ++i) {
            t[i] = new FutureTask<Object>(this, null);
            threadpool.execute(t[i]);
        }
        for (i = 0; i < this.numThreads; ++i) {
            try {
                t[i].get();
                continue;
            }
            catch (ExecutionException ee) {
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void run() {
        LoopRange str;
        while ((str = this.loopGetRange()) != null) {
            this.loopDoRange(str.start, str.end);
        }
    }

    static {
        maxThreads = 1;
    }

    protected static class PoolHandlerFactory
    implements ThreadFactory {
        protected PoolHandlerFactory() {
        }

        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setDaemon(true);
            return t;
        }
    }

    protected static class LoopRange {
        public int start;
        public int end;

        protected LoopRange() {
        }
    }
}

