/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.teolenn.util;

import fr.ens.transcriptome.teolenn.Settings;
import fr.ens.transcriptome.teolenn.util.FileUtils;
import fr.ens.transcriptome.teolenn.util.SelfLoopHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public final class ProcessUtils {
    private static Logger logger = Logger.getLogger("Teolenn");

    public static void exec(String cmd, boolean stdOutput) throws IOException {
        logger.fine("execute (Thread " + Thread.currentThread().getId() + "): " + cmd);
        long startTime = System.currentTimeMillis();
        Process p = Runtime.getRuntime().exec(cmd);
        InputStream std = p.getInputStream();
        BufferedReader stdr = new BufferedReader(new InputStreamReader(std));
        String l = null;
        while ((l = stdr.readLine()) != null) {
            if (!stdOutput) continue;
            System.out.println(l);
        }
        InputStream err = p.getInputStream();
        BufferedReader errr = new BufferedReader(new InputStreamReader(err));
        String l2 = null;
        while ((l2 = errr.readLine()) != null) {
            System.err.println(l2);
        }
        stdr.close();
        errr.close();
        ProcessUtils.logEndTime(p, cmd, startTime);
    }

    public static void execWriteOutput(String cmd, File outputFile) throws IOException {
        logger.fine("execute (Thread " + Thread.currentThread().getId() + "): " + cmd);
        long startTime = System.currentTimeMillis();
        Process p = Runtime.getRuntime().exec(cmd);
        InputStream std = p.getInputStream();
        FileOutputStream fos = new FileOutputStream(outputFile);
        FileUtils.copy(std, fos);
        InputStream err = p.getInputStream();
        BufferedReader errr = new BufferedReader(new InputStreamReader(err));
        String l2 = null;
        while ((l2 = errr.readLine()) != null) {
            System.err.println(l2);
        }
        fos.close();
        errr.close();
        ProcessUtils.logEndTime(p, cmd, startTime);
    }

    public static String execToString(String cmd) throws IOException {
        logger.fine("execute (Thread " + Thread.currentThread().getId() + "): " + cmd);
        long startTime = System.currentTimeMillis();
        Process p = Runtime.getRuntime().exec(cmd);
        InputStream std = p.getInputStream();
        BufferedReader stdr = new BufferedReader(new InputStreamReader(std));
        StringBuffer sb = new StringBuffer();
        String l1 = null;
        while ((l1 = stdr.readLine()) != null) {
            sb.append(l1);
            sb.append('\n');
        }
        InputStream err = p.getInputStream();
        BufferedReader errr = new BufferedReader(new InputStreamReader(err));
        String l2 = null;
        while ((l2 = errr.readLine()) != null) {
            System.err.println(l2);
        }
        stdr.close();
        errr.close();
        ProcessUtils.logEndTime(p, cmd, startTime);
        return sb.toString();
    }

    private static final void logEndTime(Process p, String cmd, long startTime) throws IOException {
        try {
            int exitValue = p.waitFor();
            long endTime = System.currentTimeMillis();
            if (exitValue == 1) {
                throw new IOException("Error while executing: " + cmd);
            }
            if (exitValue == 126) {
                throw new IOException("Command invoked cannot execute: " + cmd);
            }
            if (exitValue == 127) {
                throw new IOException("Command not found: " + cmd);
            }
            if (exitValue == 134) {
                throw new IOException("Abort: " + cmd);
            }
            if (exitValue == 139) {
                throw new IOException("Segmentation fault: " + cmd);
            }
            logger.fine("Done (Thread " + Thread.currentThread().getId() + ", exit code: " + exitValue + ") in " + (endTime - startTime) + " ms.");
        }
        catch (InterruptedException e) {
            logger.severe("Interrupted exception: " + e.getMessage());
        }
    }

    private ProcessUtils() {
    }

    public static class ParalellExec
    extends SelfLoopHandler {
        private final List<String> cmds = new ArrayList<String>();
        private final List<File> outputFiles = new ArrayList<File>();

        public void addTask(String cmd) {
            this.addTask(cmd, null);
        }

        public void addTask(String cmd, File outputFile) {
            if (cmd == null) {
                return;
            }
            this.cmds.add(cmd);
            this.outputFiles.add(outputFile);
        }

        public void execTasks() {
            this.setRange(0, this.cmds.size());
            this.loopProcess();
        }

        public void loopDoRange(int start, int end) {
            for (int i = start; i < end; ++i) {
                String cmd = this.cmds.get(i);
                File outputFile = this.outputFiles.get(i);
                try {
                    logger.fine("PExec: (Thread " + Thread.currentThread().getId() + ") " + cmd);
                    if (outputFile == null) {
                        ProcessUtils.exec(cmd, Settings.isStandardOutputForExecutable());
                        continue;
                    }
                    ProcessUtils.execWriteOutput(cmd, outputFile);
                    continue;
                }
                catch (IOException e) {
                    throw new RuntimeException(e.getMessage());
                }
            }
        }

        public ParalellExec(int start, int end, int min, int threads) {
            super(start, end, min, threads);
        }

        public ParalellExec(int min, int threads) {
            this(0, 0, min, threads);
        }
    }
}

