/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.teolenn.util;

import java.io.File;

public final class StringUtils {
    public static String basename(String filename) {
        if (filename == null) {
            return null;
        }
        File f = new File(filename);
        String shortName = f.getName();
        int pos = shortName.indexOf(46);
        if (pos == -1) {
            return filename;
        }
        return filename.substring(0, filename.length() - (shortName.length() - pos));
    }

    public static String extension(String filename) {
        if (filename == null) {
            return null;
        }
        File f = new File(filename);
        String shortName = f.getName();
        int pos = shortName.indexOf(46);
        if (pos == -1) {
            return "";
        }
        return filename.substring(filename.length() - (shortName.length() - pos), filename.length());
    }

    public static final String removeNonAlphaAtEndOfString(String s) {
        if (s == null) {
            return null;
        }
        int len = s.length();
        if (len == 0) {
            return s;
        }
        char c = s.charAt(len - 1);
        if (!Character.isLetter(c)) {
            return s.substring(0, len - 1);
        }
        return s;
    }

    public static final String toTimeHumanReadable(long time) {
        long min = time / 60000L;
        long minRest = time % 60000L;
        long sec = minRest / 1000L;
        long mili = minRest % 1000L;
        return String.format("%02d:%02d.%03d", min, sec, mili);
    }

    public static final String[] fastSplit(String s, String[] array) {
        if (array == null || s == null) {
            return null;
        }
        int lastPos = 0;
        int len = array.length - 1;
        for (int i = 0; i < len; ++i) {
            int pos = s.indexOf("\t", lastPos);
            if (pos == -1) {
                throw new ArrayIndexOutOfBoundsException();
            }
            array[i] = s.substring(lastPos, pos);
            lastPos = pos + 1;
        }
        array[len] = s.substring(lastPos, s.length());
        return array;
    }
}

