/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.teolenn.util;

import java.io.IOException;
import java.io.Writer;

public class UnSynchronizedBufferedWriter
extends Writer {
    private static final int CAPACITY = 8192;
    private char[] buffer = new char[8192];
    private int position = 0;
    private Writer out;
    private boolean closed = false;

    public UnSynchronizedBufferedWriter(Writer out) {
        this.out = out;
    }

    public void write(char[] text, int offset, int length) throws IOException {
        this.checkClosed();
        while (length > 0) {
            int n = Math.min(8192 - this.position, length);
            System.arraycopy(text, offset, this.buffer, this.position, n);
            this.position += n;
            offset += n;
            length -= n;
            if (this.position < 8192) continue;
            this.flushInternal();
        }
    }

    public void write(String s) throws IOException {
        this.write(s, 0, s.length());
    }

    public void write(String s, int offset, int length) throws IOException {
        this.checkClosed();
        while (length > 0) {
            int n = Math.min(8192 - this.position, length);
            s.getChars(offset, offset + n, this.buffer, this.position);
            this.position += n;
            offset += n;
            length -= n;
            if (this.position < 8192) continue;
            this.flushInternal();
        }
    }

    public void write(int c) throws IOException {
        this.checkClosed();
        if (this.position >= 8192) {
            this.flushInternal();
        }
        this.buffer[this.position] = (char)c;
        ++this.position;
    }

    public void flush() throws IOException {
        this.flushInternal();
        this.out.flush();
    }

    private void flushInternal() throws IOException {
        if (this.position != 0) {
            this.out.write(this.buffer, 0, this.position);
            this.position = 0;
        }
    }

    public void close() throws IOException {
        this.closed = true;
        this.flush();
        this.out.close();
    }

    private void checkClosed() throws IOException {
        if (this.closed) {
            throw new IOException("Writer is closed");
        }
    }
}

